/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ScatteringByteChannel;
import org.jboss.xnio.channels.StreamSourceChannel;

public class BlockingReadableByteChannel
implements ScatteringByteChannel {
    private final StreamSourceChannel delegate;

    public BlockingReadableByteChannel(StreamSourceChannel delegate) {
        this.delegate = delegate;
    }

    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        long res;
        StreamSourceChannel delegate = this.delegate;
        while ((res = delegate.read(dsts, offset, length)) == 0L) {
            delegate.awaitReadable();
        }
        return res;
    }

    public long read(ByteBuffer[] dsts) throws IOException {
        long res;
        StreamSourceChannel delegate = this.delegate;
        while ((res = delegate.read(dsts)) == 0L) {
            delegate.awaitReadable();
        }
        return res;
    }

    public int read(ByteBuffer dst) throws IOException {
        int res;
        StreamSourceChannel delegate = this.delegate;
        while ((res = delegate.read(dst)) == 0) {
            delegate.awaitReadable();
        }
        return res;
    }

    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    public void close() throws IOException {
        this.delegate.close();
    }
}

