/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.juddi.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.sql.DataSource;
import org.jboss.as.juddi.service.JUDDIConfiguration;
import org.jboss.as.juddi.service.JUDDIConfigurationService;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.logging.Logger;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public final class JUDDIDatasourceService
extends AbstractService<Void> {
    static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"juddi", "datasource"});
    private final Logger log = Logger.getLogger(JUDDIDatasourceService.class);
    private final InjectedValue<NamingStore> injectedJavaContext = new InjectedValue();
    private final InjectedValue<JUDDIConfiguration> injectedConfig = new InjectedValue();
    private DataSource datasource;

    public static ServiceController<?> addService(ServiceTarget target, ServiceListener<Object> ... listeners) {
        JUDDIDatasourceService service = new JUDDIDatasourceService();
        ServiceBuilder builder = target.addService(SERVICE_NAME, (Service)service);
        builder.addDependency(ContextNames.JAVA_CONTEXT_SERVICE_NAME, NamingStore.class, service.injectedJavaContext);
        builder.addDependency(JUDDIConfigurationService.SERVICE_NAME, JUDDIConfiguration.class, service.injectedConfig);
        builder.addListener(listeners);
        return builder.install();
    }

    private JUDDIDatasourceService() {
    }

    public void start(StartContext context) throws StartException {
        final JUDDIConfiguration config = (JUDDIConfiguration)this.injectedConfig.getValue();
        if (config.getDataSourceBinding() != null) {
            ServiceTarget childTarget = context.getChildTarget();
            ServiceBuilder builder = childTarget.addService(SERVICE_NAME.append(new String[]{"runner"}), (Service)new AbstractService<Void>(){

                public void start(StartContext context) throws StartException {
                    JUDDIDatasourceService.this.log.infof("Starting: %s", (Object)((Object)((Object)this)).getClass().getSimpleName());
                    try {
                        NamingStore namingStore = (NamingStore)JUDDIDatasourceService.this.injectedJavaContext.getValue();
                        String lookup = config.getDataSourceBinding();
                        if (lookup == null || !lookup.startsWith("java:")) {
                            throw new IllegalStateException("Datasource lookup expected in java context: %s" + lookup);
                        }
                        long timeout = 2000L;
                        while (JUDDIDatasourceService.this.datasource == null && timeout > 0L) {
                            try {
                                JUDDIDatasourceService.this.datasource = (DataSource)namingStore.lookup((Name)new CompositeName(lookup.substring(5)));
                            }
                            catch (Exception ex) {
                                Thread.sleep(200L);
                                timeout -= 200L;
                            }
                        }
                        if (JUDDIDatasourceService.this.datasource == null) {
                            throw new IllegalStateException("Cannot obtain data source: " + lookup);
                        }
                        if (config.isDropOnStart()) {
                            JUDDIDatasourceService.this.log.debug((Object)"Drop juddi tables on start");
                            JUDDIDatasourceService.this.locateAndRunScript("juddi_drop_db.ddl", Logger.Level.DEBUG);
                        }
                        if (config.isCreateOnStart()) {
                            JUDDIDatasourceService.this.log.debug((Object)"Create juddi tables on start");
                            JUDDIDatasourceService.this.locateAndRunScript("juddi_create_db.ddl", Logger.Level.ERROR);
                            JUDDIDatasourceService.this.locateAndRunScript("juddi_data.ddl", Logger.Level.ERROR);
                        }
                    }
                    catch (Exception ex) {
                        JUDDIDatasourceService.this.log.errorf((Throwable)ex, "Cannot start JUDDI service", new Object[0]);
                    }
                }

                public void stop(StopContext context) {
                    JUDDIDatasourceService.this.log.infof("Stopping: %s", (Object)((Object)((Object)this)).getClass().getSimpleName());
                    try {
                        JUDDIConfiguration config2 = (JUDDIConfiguration)JUDDIDatasourceService.this.injectedConfig.getValue();
                        if (config2.isDropOnStop()) {
                            try {
                                JUDDIDatasourceService.this.log.debug((Object)"Drop juddi tables on sop");
                                JUDDIDatasourceService.this.locateAndRunScript("juddi_drop_db.ddl", Logger.Level.DEBUG);
                            }
                            catch (SQLException ex) {
                                JUDDIDatasourceService.this.log.errorf("Cannot drop JAXR tables: %s", (Object)ex);
                            }
                        }
                    }
                    catch (Exception ex) {
                        JUDDIDatasourceService.this.log.errorf((Throwable)ex, "Failure stopping JUDDI service", new Object[0]);
                    }
                }
            });
            builder.addDependency(ServiceName.JBOSS.append(new String[]{"data-source", config.getDataSourceBinding()}));
            builder.install();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void locateAndRunScript(String name, Logger.Level errorlevel) throws SQLException, IOException {
        this.log.infof("RunScript: %s", (Object)name);
        InputStream input = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("META-INF/ddl/" + name);
        if (input == null) {
            this.log.errorf("Cannot load DDL script: %s", (Object)name);
            return;
        }
        try {
            this.runScript(input, errorlevel);
        }
        finally {
            input.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runScript(InputStream stream, Logger.Level errorlevel) throws SQLException, IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        Connection connection = this.datasource.getConnection();
        if (connection == null) {
            this.log.errorf("Cannot obtain connection", new Object[0]);
            return;
        }
        try {
            String nextLine;
            StringBuffer nextStatement = new StringBuffer();
            while ((nextLine = reader.readLine()) != null) {
                if ((nextLine = nextLine.trim()).startsWith("--")) continue;
                nextStatement.append(nextLine);
                if (!nextLine.endsWith(";")) continue;
                String sqlStatement = nextStatement.substring(0, nextStatement.indexOf(";"));
                this.log.debugf("Statement to execute: '%s'", (Object)sqlStatement);
                try {
                    Statement statement = connection.createStatement();
                    statement.execute(sqlStatement);
                    statement.close();
                }
                catch (SQLException e) {
                    String msg = "Could not execute statement: %s";
                    this.log.logf(errorlevel, msg, (Object)e.getLocalizedMessage());
                }
                finally {
                    nextStatement = new StringBuffer();
                }
            }
        }
        finally {
            connection.close();
        }
    }
}

