/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.juddi.service;

import org.jboss.msc.service.ServiceName;

public class JUDDIConfiguration {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"jaxr", "configuration"});
    public static final boolean DEFAULT_DROPONSTART = false;
    public static final boolean DEFAULT_CREATEONSTART = false;
    public static final boolean DEFAULT_DROPONSTOP = false;
    private String dataSourceBinding;
    private boolean dropOnStart;
    private boolean createOnStart;
    private boolean dropOnStop;

    public JUDDIConfiguration() {
        this.init();
    }

    public void init() {
        this.dataSourceBinding = null;
        this.dropOnStart = false;
        this.createOnStart = false;
        this.dropOnStop = false;
    }

    public void applyUpdateToConfig(String attributeName, String attributeValue) {
        if (attributeValue != null) {
            if (attributeName.equals("datasource")) {
                this.setDataSourceBinding(attributeValue);
            } else if (attributeName.equals("drop-on-start")) {
                this.setDropOnStart(Boolean.valueOf(attributeValue));
            } else if (attributeName.equals("create-on-start")) {
                this.setCreateOnStart(Boolean.valueOf(attributeValue));
            } else if (attributeName.equals("drop-on-stop")) {
                this.setDropOnStop(Boolean.valueOf(attributeValue));
            } else {
                throw new IllegalArgumentException("Invalid attribute name: " + attributeName);
            }
        }
    }

    public boolean isDropOnStop() {
        return this.dropOnStop;
    }

    public boolean isDropOnStart() {
        return this.dropOnStart;
    }

    public boolean isCreateOnStart() {
        return this.createOnStart;
    }

    public String getDataSourceBinding() {
        return this.dataSourceBinding;
    }

    public void setDataSourceBinding(String dataSourceBinding) {
        this.dataSourceBinding = dataSourceBinding;
    }

    public void setCreateOnStart(boolean createOnStart) {
        this.createOnStart = createOnStart;
    }

    public void setDropOnStart(boolean dropOnStart) {
        this.dropOnStart = dropOnStart;
    }

    public void setDropOnStop(boolean dropOnStop) {
        this.dropOnStop = dropOnStop;
    }
}

