/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxr.service;

import java.util.Collections;
import java.util.Dictionary;
import java.util.Set;
import org.jboss.as.jaxr.service.JAXRConfiguration;
import org.jboss.as.osgi.service.ConfigAdminListener;
import org.jboss.as.osgi.service.ConfigAdminService;
import org.jboss.logging.Logger;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;

public class JAXRConfigAdminService
extends AbstractService<JAXRConfiguration> {
    private final Logger log = Logger.getLogger(JAXRConfigAdminService.class);
    private final InjectedValue<ConfigAdminService> injectedConfigAdmin = new InjectedValue();
    private final JAXRConfiguration config = new JAXRConfiguration();

    public static ServiceController<?> addService(ServiceTarget target, ServiceListener<Object> ... listeners) {
        JAXRConfigAdminService service = new JAXRConfigAdminService();
        ServiceBuilder builder = target.addService(JAXRConfiguration.SERVICE_NAME, (Service)service);
        builder.addDependency(ConfigAdminService.SERVICE_NAME, ConfigAdminService.class, service.injectedConfigAdmin);
        builder.addListener(listeners);
        return builder.install();
    }

    private JAXRConfigAdminService() {
    }

    public void start(StartContext context) throws StartException {
        ConfigAdminService configAdmin = (ConfigAdminService)this.injectedConfigAdmin.getValue();
        configAdmin.addListener(new ConfigAdminListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void configurationModified(String pid, Dictionary<String, String> props) {
                JAXRConfiguration jAXRConfiguration = JAXRConfigAdminService.this.config;
                synchronized (jAXRConfiguration) {
                    JAXRConfigAdminService.this.config.init();
                    JAXRConfigAdminService.this.log.infof("JAXR Configuration: %s", props);
                    if (props != null) {
                        for (String attr : JAXRConfiguration.REQUIRED_ATTRIBUTES) {
                            String value = props.get(attr);
                            JAXRConfigAdminService.this.config.applyUpdateToConfig(attr, value);
                        }
                    }
                }
            }

            public Set<String> getPIDs() {
                return Collections.singleton(JAXRConfiguration.class.getName());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAXRConfiguration getValue() throws IllegalStateException {
        JAXRConfiguration jAXRConfiguration = this.config;
        synchronized (jAXRConfiguration) {
            return this.config;
        }
    }
}

