/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.plugins.tools;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.jboss.ws.plugins.tools.AbstractToolsMojo;
import org.jboss.wsf.spi.tools.WSContractProvider;

public abstract class AbstractWsProvideMojo
extends AbstractToolsMojo {
    private boolean generateWsdl;
    protected File resourceDirectory;
    protected File sourceDirectory;
    private String endpointClass;

    public void execute() throws MojoExecutionException {
        Log log = this.getLog();
        if (this.endpointClass == null) {
            this.getLog().info((CharSequence)"No service endpoint implementation class specified, nothing to do.");
            return;
        }
        if (this.verbose.booleanValue()) {
            log.info((CharSequence)"Classpath:");
            for (String s : this.getClasspathElements()) {
                log.info((CharSequence)(" " + s));
            }
        }
        ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader loader = this.getMavenClasspathAwareClassLoader(origLoader);
        Thread.currentThread().setContextClassLoader(loader);
        try {
            WSContractProvider provider = WSContractProvider.newInstance();
            this.setupProvider(provider, loader);
            provider.provide(this.endpointClass);
            this.updateProjectSourceRoots();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while running wsconsume", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(origLoader);
        }
    }

    private void setupProvider(WSContractProvider provider, ClassLoader loader) {
        provider.setClassLoader(loader);
        provider.setExtension(this.extension.booleanValue());
        provider.setGenerateSource(this.generateSource.booleanValue());
        provider.setGenerateWsdl(this.generateWsdl);
        provider.setMessageStream(System.out);
        File outputDir = this.getOutputDirectory();
        if (outputDir != null) {
            provider.setOutputDirectory(outputDir);
        }
        if (this.resourceDirectory != null) {
            provider.setResourceDirectory(this.resourceDirectory);
        }
        if (this.sourceDirectory != null) {
            provider.setSourceDirectory(this.sourceDirectory);
        }
    }

    public boolean isGenerateWsdl() {
        return this.generateWsdl;
    }

    public File getResourceDirectory() {
        return this.resourceDirectory;
    }

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public String getEndpointClass() {
        return this.endpointClass;
    }
}

