/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.plugins.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.project.MavenProject;

abstract class AbstractToolsMojo
extends AbstractMojo {
    protected MavenProject project;
    protected Boolean generateSource = true;
    protected Boolean extension;
    protected Boolean verbose;
    protected String argLine;
    protected Boolean fork;

    AbstractToolsMojo() {
    }

    public abstract File getOutputDirectory();

    public abstract List<String> getClasspathElements();

    public abstract List<Artifact> getPluginArtifacts();

    protected abstract void updateProjectSourceRoots();

    protected URLClassLoader getMavenClasspathAwareClassLoader() {
        List<String> classpath = this.getClasspathElements();
        int size = classpath.size();
        URL[] urls = new URL[size];
        for (int i = 0; i < size; ++i) {
            try {
                urls[i] = new File(classpath.get(i)).toURI().toURL();
                continue;
            }
            catch (MalformedURLException mue) {
                this.getLog().warn((CharSequence)("Skipping invalid classpath element: " + classpath.get(i)));
            }
        }
        return new URLClassLoader(urls, null);
    }

    protected List<File> getRequiredPluginDependencyPaths() {
        ArrayList<File> result = new ArrayList<File>(3);
        for (Artifact s : this.getPluginArtifacts()) {
            if ("org.jboss.ws".equals(s.getGroupId()) && "jbossws-common-tools".equals(s.getArtifactId())) {
                result.add(s.getFile());
                continue;
            }
            if ("gnu-getopt".equals(s.getGroupId()) && "getopt".equals(s.getArtifactId())) {
                result.add(s.getFile());
                continue;
            }
            if ("gnu.getopt".equals(s.getGroupId()) && "java-getopt".equals(s.getArtifactId())) {
                result.add(s.getFile());
                continue;
            }
            if (!"log4j".equals(s.getGroupId()) || !"log4j".equals(s.getArtifactId())) continue;
            result.add(s.getFile());
        }
        return result;
    }

    public Boolean getExtension() {
        return this.extension;
    }

    public Boolean isVerbose() {
        return this.verbose;
    }

    public String getArgLine() {
        return this.argLine;
    }

    public Boolean isFork() {
        return this.fork;
    }

    public File createJar(List<String> classPath, String startClassName) throws IOException {
        File tempDirectory = new File(this.getOutputDirectory().getParentFile(), "jaxws-tools");
        tempDirectory.mkdirs();
        File file = File.createTempFile("jaxws-tools-maven-plugin-classpath-", ".jar", tempDirectory);
        FileOutputStream fos = new FileOutputStream(file);
        JarOutputStream jos = new JarOutputStream(fos);
        jos.setLevel(0);
        JarEntry je = new JarEntry("META-INF/MANIFEST.MF");
        jos.putNextEntry(je);
        Manifest man = new Manifest();
        StringBuilder cp = new StringBuilder();
        for (String el : classPath) {
            cp.append(new File(el).toURI().toURL().toExternalForm());
            cp.append(" ");
        }
        List<File> pluginDeps = this.getRequiredPluginDependencyPaths();
        for (File f : pluginDeps) {
            cp.append(f.toURI().toURL().toExternalForm());
            cp.append(" ");
        }
        man.getMainAttributes().putValue("Manifest-Version", "1.0");
        man.getMainAttributes().putValue("Class-Path", cp.toString().trim());
        man.getMainAttributes().putValue("Main-Class", startClassName);
        man.write(jos);
        jos.close();
        return file;
    }
}

