/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.jbws.embedded;

import java.util.ArrayList;
import java.util.UUID;
import org.jboss.wsf.common.ResourceLoaderAdapter;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentModelFactory;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;

public class DeploymentModelBuilder {
    private Deployment deployment;
    private DeploymentModelFactory modelFactory;

    public DeploymentModelBuilder() {
        SPIProvider spi = SPIProviderResolver.getInstance().getProvider();
        this.modelFactory = (DeploymentModelFactory)spi.getSPI(DeploymentModelFactory.class);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        this.deployment = this.modelFactory.newDeployment(UUID.randomUUID().toString(), contextClassLoader);
        this.deployment.setRuntimeClassLoader(contextClassLoader);
        ((ArchiveDeployment)this.deployment).setRootFile((UnifiedVirtualFile)new ResourceLoaderAdapter());
        this.deployment.setType(Deployment.DeploymentType.JAXWS_JSE);
        this.deployment.setService(this.modelFactory.newService());
    }

    public DeploymentModelBuilder setContextRoot(String contextRoot) {
        assert (contextRoot != null);
        this.deployment.getService().setContextRoot(contextRoot);
        return this;
    }

    public DeploymentModelBuilder addEndpoint(String className, String urlPattern) {
        assert (className != null);
        assert (urlPattern != null);
        Endpoint endpoint = this.modelFactory.newEndpoint("org.jboss.test.ws.embedded.HelloWorldEndpoint");
        endpoint.setShortName(className + "-Endpoint");
        endpoint.setURLPattern(urlPattern);
        this.deployment.getService().addEndpoint(endpoint);
        return this;
    }

    public Deployment build() {
        if (null == this.deployment.getService().getContextRoot()) {
            throw new IllegalArgumentException("No context root");
        }
        ArrayList<String> usedPatterns = new ArrayList<String>();
        for (Endpoint ep : this.deployment.getService().getEndpoints()) {
            String urlPattern = ep.getURLPattern();
            if (null == urlPattern) {
                throw new IllegalArgumentException("No urlPattern");
            }
            for (String usedPattern : usedPatterns) {
                if (!urlPattern.equals(usedPattern)) continue;
                throw new IllegalArgumentException("URL pattern already used: " + urlPattern);
            }
            usedPatterns.add(urlPattern);
        }
        return this.deployment;
    }
}

