/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.wsf.stack.metro;

import java.util.Map;
import java.util.HashMap;

/**
 * @author Heiko Braun
 */
class MessageStreamContext
{
   public static final int STATUS_INTERNAL_SERVER_ERROR = 500;
   public static final String CONTENT_TYPE = "Content-Type";
   
   private Map<String, String> requestContext = new HashMap<String, String>();
   private Map<String, String> responseContext = new HashMap<String, String>();

   public Map<String, String> getRequestContext()
   {
      return requestContext;
   }

   public void setRequestContext(Map<String, String> requestContext)
   {
      this.requestContext = requestContext;
   }

   public Map<String, String> getResponseContext()
   {
      return responseContext;
   }

   public void setResponseContext(Map<String, String> responseContext)
   {
      this.responseContext = responseContext;
   }
}
