/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.wsf.stack.metro.metadata;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.jboss.logging.Logger;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;

import com.sun.xml.ws.transport.http.ResourceLoader;

/**
 * @author Heiko.Braun@jboss.com
 * @author alessio.soldano@jboss.com
 */
public class VFSResourceLoader implements ResourceLoader
{

   private static final Logger log = Logger.getLogger(VFSResourceLoader.class);

   UnifiedVirtualFile vfs;

   public VFSResourceLoader(UnifiedVirtualFile vfs)
   {
      this.vfs = vfs;
   }

   public URL getResource(String path) throws MalformedURLException
   {
      try
      {
         if(path.startsWith("/"))
            path = path.substring(1, path.length());

         UnifiedVirtualFile uvf = vfs.findChild(path);
         return uvf != null ? uvf.toURL() : null;
      }
      catch (IOException e)
      {
         throw new MalformedURLException(e.getMessage());
      }
   }

   public URL getCatalogFile() throws MalformedURLException
   {
      URL resource = null;
      try
      {
         resource = getResource("/WEB-INF/jax-ws-catalog.xml");
      }
      catch (MalformedURLException e)
      {
         // ignore
      }
      return resource;
   }

   public Set<String> getResourcePaths(String path)
   {
      Set<String> resources = new HashSet<String>();
      resources.addAll(getFileResources(path));
      return resources;
   }
   
   private List<String> getFileResources(String path)
   {
      List<String> resources = new ArrayList<String>();
      try
      {
         if(path.startsWith("/"))
            path = path.substring(1, path.length());
         List<UnifiedVirtualFile> list = vfs.findChild(path).getChildren();
         for (UnifiedVirtualFile uvf : list)
         {
            String name = uvf.getName();
            if (name != null && (name.endsWith(File.separator) || name.endsWith(".xml") || name.endsWith(".xsd") || name.endsWith(".wsdl")))
               resources.add(path + uvf.getName());
         }
      }
      catch (Throwable e)
      {
         log.error("Failed to read resource paths from '"+path+"': ", e);
      }
      return resources;
   }
}
