/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.injection;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.webservices.injection.WSEndpointHandlersMapping;
import org.jboss.as.webservices.logging.WSLogger;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.DotNames;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.vfs.VirtualFile;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainsMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainsMetaDataParser;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;

public final class WSHandlerChainAnnotationProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = phaseContext.getDeploymentUnit();
        if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)unit)) {
            return;
        }
        List<ResourceRoot> resourceRoots = ASHelper.getResourceRoots(unit);
        if (resourceRoots == null) {
            return;
        }
        WSEndpointHandlersMapping mapping = new WSEndpointHandlersMapping();
        Index index = null;
        for (ResourceRoot resourceRoot : resourceRoots) {
            index = (Index)resourceRoot.getAttachment(Attachments.ANNOTATION_INDEX);
            if (index == null) continue;
            WSHandlerChainAnnotationProcessor.processHandlerChainAnnotations(resourceRoot, index, mapping);
        }
        if (!mapping.isEmpty()) {
            unit.putAttachment(WSAttachmentKeys.WS_ENDPOINT_HANDLERS_MAPPING_KEY, (Object)mapping);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private static void processHandlerChainAnnotations(ResourceRoot resourceRoot, Index index, WSEndpointHandlersMapping mapping) throws DeploymentUnitProcessingException {
        String endpointClass;
        AnnotationInstance handlerChainAnnotationInstance;
        ClassInfo classInfo;
        AnnotationTarget annotationTarget;
        List webServiceAnnotations = index.getAnnotations(DotNames.WEB_SERVICE_ANNOTATION);
        List webServiceProviderAnnotations = index.getAnnotations(DotNames.WEB_SERVICE_PROVIDER_ANNOTATION);
        for (AnnotationInstance annotationInstance : webServiceAnnotations) {
            annotationTarget = annotationInstance.target();
            if (!(annotationTarget instanceof ClassInfo) || !WSHandlerChainAnnotationProcessor.isJaxwsEndpoint(classInfo = (ClassInfo)annotationTarget, index)) continue;
            handlerChainAnnotationInstance = WSHandlerChainAnnotationProcessor.getHandlerChainAnnotationInstance(classInfo);
            if (handlerChainAnnotationInstance == null) {
                handlerChainAnnotationInstance = WSHandlerChainAnnotationProcessor.getEndpointInterfaceHandlerChainAnnotationInstance(classInfo, index);
            }
            if (handlerChainAnnotationInstance == null) continue;
            endpointClass = classInfo.name().toString();
            WSHandlerChainAnnotationProcessor.processHandlerChainAnnotation(resourceRoot, handlerChainAnnotationInstance, endpointClass, mapping);
        }
        for (AnnotationInstance annotationInstance : webServiceProviderAnnotations) {
            annotationTarget = annotationInstance.target();
            if (!(annotationTarget instanceof ClassInfo) || (handlerChainAnnotationInstance = WSHandlerChainAnnotationProcessor.getHandlerChainAnnotationInstance(classInfo = (ClassInfo)annotationTarget)) == null || !WSHandlerChainAnnotationProcessor.isJaxwsEndpoint(classInfo, index)) continue;
            endpointClass = classInfo.name().toString();
            WSHandlerChainAnnotationProcessor.processHandlerChainAnnotation(resourceRoot, handlerChainAnnotationInstance, endpointClass, mapping);
        }
    }

    private static AnnotationInstance getHandlerChainAnnotationInstance(ClassInfo classInfo) {
        List list = (List)classInfo.annotations().get(DotNames.HANDLER_CHAIN_ANNOTATION);
        return list != null && !list.isEmpty() ? (AnnotationInstance)list.iterator().next() : null;
    }

    private static AnnotationInstance getEndpointInterfaceHandlerChainAnnotationInstance(ClassInfo classInfo, Index index) {
        ClassInfo intfClassInfo;
        String intf;
        AnnotationValue av = ((AnnotationInstance)((List)classInfo.annotations().get(DotNames.WEB_SERVICE_ANNOTATION)).iterator().next()).value("endpointInterface");
        if (av != null && (intf = av.asString()) != null && !intf.isEmpty() && (intfClassInfo = index.getClassByName(DotName.createSimple((String)intf))) != null && ASHelper.isJaxwsEndpointInterface(intfClassInfo)) {
            return WSHandlerChainAnnotationProcessor.getHandlerChainAnnotationInstance(intfClassInfo);
        }
        return null;
    }

    private static void processHandlerChainAnnotation(ResourceRoot resourceRoot, AnnotationInstance handlerChainAnnotation, String endpointClass, WSEndpointHandlersMapping mapping) throws DeploymentUnitProcessingException {
        String handlerChainConfigFile = handlerChainAnnotation.value("file").asString();
        InputStream is = null;
        try {
            is = WSHandlerChainAnnotationProcessor.getInputStream(resourceRoot, handlerChainConfigFile, endpointClass);
            Set<String> endpointHandlers = WSHandlerChainAnnotationProcessor.getHandlers(is);
            if (endpointHandlers.size() > 0) {
                mapping.registerEndpointHandlers(endpointClass, endpointHandlers);
            } else {
                WSLogger.ROOT_LOGGER.invalidHandlerChainFile(handlerChainConfigFile);
            }
        }
        catch (IOException e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static InputStream getInputStream(ResourceRoot resourceRoot, String handlerChainConfigFile, String annotatedClassName) throws IOException {
        if (handlerChainConfigFile.startsWith("file://") || handlerChainConfigFile.startsWith("http://")) {
            return new URL(handlerChainConfigFile).openStream();
        }
        URI classURI = null;
        try {
            classURI = new URI(annotatedClassName.replace('.', '/'));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        String handlerChainConfigFileResourcePath = classURI.resolve(handlerChainConfigFile).toString();
        VirtualFile config = resourceRoot.getRoot().getChild(handlerChainConfigFileResourcePath);
        if (config.exists() && config.isFile()) {
            return config.openStream();
        }
        throw WSLogger.ROOT_LOGGER.missingHandlerChainConfigFile(handlerChainConfigFileResourcePath, resourceRoot);
    }

    private static Set<String> getHandlers(InputStream is) throws IOException {
        HashSet<String> retVal = new HashSet<String>();
        UnifiedHandlerChainsMetaData handlerChainsUMDM = UnifiedHandlerChainsMetaDataParser.parse((InputStream)is);
        if (handlerChainsUMDM != null) {
            for (UnifiedHandlerChainMetaData handlerChainUMDM : handlerChainsUMDM.getHandlerChains()) {
                for (UnifiedHandlerMetaData handlerUMDM : handlerChainUMDM.getHandlers()) {
                    retVal.add(handlerUMDM.getHandlerClass());
                }
            }
        }
        return retVal;
    }

    private static boolean isJaxwsEndpoint(ClassInfo clazz, Index index) {
        short flags = clazz.flags();
        if (Modifier.isInterface(flags)) {
            return false;
        }
        if (Modifier.isAbstract(flags)) {
            return false;
        }
        if (!Modifier.isPublic(flags)) {
            return false;
        }
        if (ASHelper.isJaxwsService(clazz, index)) {
            return false;
        }
        if (Modifier.isFinal(flags)) {
            return false;
        }
        boolean isWebService = clazz.annotations().containsKey(DotNames.WEB_SERVICE_ANNOTATION);
        boolean isWebServiceProvider = clazz.annotations().containsKey(DotNames.WEB_SERVICE_PROVIDER_ANNOTATION);
        return isWebService || isWebServiceProvider;
    }
}

