/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2014, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.wsf.spi.metadata.j2ee;

/**
 * The container independent EJB security meta data class  
 *
 * @author Thomas.Diesler@jboss.org
 * @since 05-May-2006
 */
public class EJBSecurityMetaData
{
   private final String authMethod;
   private final String realmName;
   private final String transportGuarantee;
   private final boolean secureWSDLAccess;

   public EJBSecurityMetaData(String authMethod, String transportGuarantee, boolean secureWSDLAccess)
   {
      this(authMethod, null, transportGuarantee, secureWSDLAccess);
   }
   
   public EJBSecurityMetaData(String authMethod, String realmName, String transportGuarantee, boolean secureWSDLAccess)
   {
      this.authMethod = authMethod;
      this.realmName = realmName;
      this.transportGuarantee = transportGuarantee;
      this.secureWSDLAccess = secureWSDLAccess;
   }

   public String getAuthMethod()
   {
      return authMethod;
   }

   public String getTransportGuarantee()
   {
      return transportGuarantee;
   }

   public boolean getSecureWSDLAccess()
   {
      return secureWSDLAccess;
   }
   
   public String getRealmName() 
   {
      return realmName;
   }
}
