/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.metadata.webservices;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.WebServiceException;
import org.jboss.wsf.spi.Messages;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.webservices.JBossPortComponentMetaData;
import org.jboss.wsf.spi.metadata.webservices.JBossWebserviceDescriptionMetaData;
import org.jboss.wsf.spi.metadata.webservices.JBossWebservicesMetaData;
import org.jboss.wsf.spi.util.StAXUtils;

public class JBossWebservicesFactory {
    private URL descriptorURL;

    public JBossWebservicesFactory(URL descriptorURL) {
        this.descriptorURL = descriptorURL;
    }

    public URL getDescriptorURL() {
        return this.descriptorURL;
    }

    public JBossWebservicesMetaData loadFromVFSRoot(UnifiedVirtualFile root) {
        JBossWebservicesMetaData webservices = null;
        UnifiedVirtualFile wsdd = root.findChildFailSafe("META-INF/jboss-webservices.xml");
        if (null == wsdd) {
            wsdd = root.findChildFailSafe("WEB-INF/jboss-webservices.xml");
        }
        if (wsdd != null) {
            return this.load(wsdd.toURL());
        }
        return webservices;
    }

    public JBossWebservicesMetaData load(URL wsddUrl) {
        InputStream is = null;
        try {
            is = wsddUrl.openStream();
            XMLStreamReader xmlr = StAXUtils.createXMLStreamReader(is);
            JBossWebservicesMetaData jBossWebservicesMetaData = this.parse(xmlr, wsddUrl);
            return jBossWebservicesMetaData;
        }
        catch (Exception e) {
            throw Messages.MESSAGES.failedToUnmarshall(e, wsddUrl);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public JBossWebservicesMetaData parse(InputStream is) {
        return this.parse(is, null);
    }

    public JBossWebservicesMetaData parse(InputStream is, URL descriptorURL) {
        try {
            XMLStreamReader xmlr = StAXUtils.createXMLStreamReader(is);
            return this.parse(xmlr, descriptorURL);
        }
        catch (Exception e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    public JBossWebservicesMetaData parse(XMLStreamReader reader) throws XMLStreamException {
        return this.parse(reader, null);
    }

    private JBossWebservicesMetaData parse(XMLStreamReader reader, URL descriptorURL) throws XMLStreamException {
        int iterate;
        try {
            iterate = reader.nextTag();
        }
        catch (XMLStreamException e) {
            iterate = reader.nextTag();
        }
        JBossWebservicesMetaData metadata = null;
        switch (iterate) {
            case 2: {
                break;
            }
            case 1: {
                if (StAXUtils.match(reader, "http://www.jboss.com/xml/ns/javaee", "webservices")) {
                    String nsUri = reader.getNamespaceURI();
                    metadata = this.parseWebservices(reader, nsUri, descriptorURL);
                    break;
                }
                throw Messages.MESSAGES.unexpectedElement(descriptorURL != null ? descriptorURL.toString() : "jboss-webservices.xml", reader.getLocalName());
            }
        }
        return metadata;
    }

    private JBossWebservicesMetaData parseWebservices(XMLStreamReader reader, String nsUri, URL descriptorURL) throws XMLStreamException {
        JBossWebservicesMetaData metadata = new JBossWebservicesMetaData(descriptorURL);
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match(reader, nsUri, "webservices")) {
                        return metadata;
                    }
                    throw Messages.MESSAGES.unexpectedEndTag(this.getDescriptorForLogs(), reader.getLocalName());
                }
                case 1: {
                    if (StAXUtils.match(reader, nsUri, "context-root")) {
                        metadata.setContextRoot(this.getElementText(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "config-name")) {
                        metadata.setConfigName(this.getElementText(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "config-file")) {
                        metadata.setConfigFile(this.getElementText(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "property")) {
                        this.parseProperty(reader, nsUri, metadata);
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "port-component")) {
                        metadata.addPortComponent(this.parsePortComponent(reader, nsUri));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "webservice-description")) {
                        metadata.addWebserviceDescription(this.parseWebserviceDescription(reader, nsUri));
                        break;
                    }
                    throw Messages.MESSAGES.unexpectedElement(this.getDescriptorForLogs(), reader.getLocalName());
                }
            }
        }
        throw Messages.MESSAGES.reachedEndOfXMLDocUnexpectedly(this.getDescriptorForLogs());
    }

    private JBossPortComponentMetaData parsePortComponent(XMLStreamReader reader, String nsUri) throws XMLStreamException {
        JBossPortComponentMetaData pc = new JBossPortComponentMetaData();
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match(reader, nsUri, "port-component")) {
                        return pc;
                    }
                    throw Messages.MESSAGES.unexpectedEndTag(this.getDescriptorForLogs(), reader.getLocalName());
                }
                case 1: {
                    if (StAXUtils.match(reader, nsUri, "ejb-name")) {
                        pc.setEjbName(this.getElementText(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "port-component-name")) {
                        pc.setPortComponentName(this.getElementText(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "port-component-uri")) {
                        pc.setPortComponentURI(this.getElementText(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "auth-method")) {
                        pc.setAuthMethod(this.getElementText(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "transport-guarantee")) {
                        pc.setTransportGuarantee(this.getElementText(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "secure-wsdl-access")) {
                        pc.setSecureWSDLAccess(StAXUtils.elementAsBoolean(reader));
                        break;
                    }
                    throw Messages.MESSAGES.unexpectedElement(this.getDescriptorForLogs(), reader.getLocalName());
                }
            }
        }
        throw Messages.MESSAGES.reachedEndOfXMLDocUnexpectedly(this.getDescriptorForLogs());
    }

    private JBossWebserviceDescriptionMetaData parseWebserviceDescription(XMLStreamReader reader, String nsUri) throws XMLStreamException {
        JBossWebserviceDescriptionMetaData description = new JBossWebserviceDescriptionMetaData();
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match(reader, nsUri, "webservice-description")) {
                        return description;
                    }
                    throw Messages.MESSAGES.unexpectedEndTag(this.getDescriptorForLogs(), reader.getLocalName());
                }
                case 1: {
                    if (StAXUtils.match(reader, nsUri, "webservice-description-name")) {
                        description.setWebserviceDescriptionName(this.getElementText(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "wsdl-publish-location")) {
                        description.setWsdlPublishLocation(this.getElementText(reader));
                        break;
                    }
                    throw Messages.MESSAGES.unexpectedElement(this.getDescriptorForLogs(), reader.getLocalName());
                }
            }
        }
        throw Messages.MESSAGES.reachedEndOfXMLDocUnexpectedly(this.getDescriptorForLogs());
    }

    private void parseProperty(XMLStreamReader reader, String nsUri, JBossWebservicesMetaData metadata) throws XMLStreamException {
        String name = null;
        String value = null;
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match(reader, nsUri, "property")) {
                        if (name == null) {
                            throw Messages.MESSAGES.couldNotGetPropertyName(this.getDescriptorForLogs());
                        }
                        metadata.setProperty(name, value);
                        return;
                    }
                    throw Messages.MESSAGES.unexpectedEndTag(this.getDescriptorForLogs(), reader.getLocalName());
                }
                case 1: {
                    if (StAXUtils.match(reader, nsUri, "name")) {
                        name = this.getElementText(reader);
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "value")) {
                        value = this.getElementText(reader);
                        break;
                    }
                    throw Messages.MESSAGES.unexpectedElement(this.getDescriptorForLogs(), reader.getLocalName());
                }
            }
        }
        throw Messages.MESSAGES.reachedEndOfXMLDocUnexpectedly(this.getDescriptorForLogs());
    }

    protected String getElementText(XMLStreamReader reader) throws XMLStreamException {
        return StAXUtils.elementAsString(reader);
    }

    private String getDescriptorForLogs() {
        return this.descriptorURL != null ? this.descriptorURL.toString() : "jboss-webservices.xml";
    }
}

