/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.metadata.j2ee.serviceref;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.wsf.spi.Messages;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedStubPropertyMetaData;

public class UnifiedPortComponentRefMetaData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private UnifiedServiceRefMetaData serviceRefMetaData;
    private String serviceEndpointInterface;
    private String portComponentLink;
    private QName portQName;
    private List<UnifiedStubPropertyMetaData> stubProperties = new ArrayList<UnifiedStubPropertyMetaData>(2);
    private String configName;
    private String configFile;
    private boolean addressingAnnotationSpecified;
    private boolean addressingEnabled;
    private boolean addressingRequired;
    private String addressingResponses = "ALL";
    private boolean mtomEnabled;
    private int mtomThreshold;
    private boolean respectBindingAnnotationSpecified;
    private boolean respectBindingEnabled;

    public UnifiedPortComponentRefMetaData(UnifiedServiceRefMetaData serviceRefMetaData) {
        this.serviceRefMetaData = serviceRefMetaData;
    }

    public UnifiedServiceRefMetaData getServiceRefMetaData() {
        return this.serviceRefMetaData;
    }

    public void setAddressingAnnotationSpecified(boolean addressingAnnotationSpecified) {
        this.addressingAnnotationSpecified = addressingAnnotationSpecified;
    }

    public boolean isAddressingAnnotationSpecified() {
        return this.addressingAnnotationSpecified;
    }

    public void setAddressingEnabled(boolean addressingEnabled) {
        this.addressingEnabled = addressingEnabled;
    }

    public boolean isAddressingEnabled() {
        return this.addressingEnabled;
    }

    public void setAddressingRequired(boolean addressingRequired) {
        this.addressingRequired = addressingRequired;
    }

    public boolean isAddressingRequired() {
        return this.addressingRequired;
    }

    public void setAddressingResponses(String responsesTypes) {
        if (!("ANONYMOUS".equals(responsesTypes) || "NON_ANONYMOUS".equals(responsesTypes) || "ALL".equals(responsesTypes))) {
            throw Messages.MESSAGES.unsupportedAddressingResponseType(responsesTypes);
        }
        this.addressingResponses = responsesTypes;
    }

    public String getAddressingResponses() {
        return this.addressingResponses;
    }

    public void setMtomEnabled(boolean mtomEnabled) {
        this.mtomEnabled = mtomEnabled;
    }

    public boolean isMtomEnabled() {
        return this.mtomEnabled;
    }

    public void setMtomThreshold(int mtomThreshold) {
        this.mtomThreshold = mtomThreshold;
    }

    public int getMtomThreshold() {
        return this.mtomThreshold;
    }

    public void setRespectBindingAnnotationSpecified(boolean respectBindingAnnotationSpecified) {
        this.respectBindingAnnotationSpecified = respectBindingAnnotationSpecified;
    }

    public boolean isRespectBindingAnnotationSpecified() {
        return this.respectBindingAnnotationSpecified;
    }

    public void setRespectBindingEnabled(boolean respectBindingEnabled) {
        this.respectBindingEnabled = respectBindingEnabled;
    }

    public boolean isRespectBindingEnabled() {
        return this.respectBindingEnabled;
    }

    public String getPortComponentLink() {
        return this.portComponentLink;
    }

    public void setPortComponentLink(String portComponentLink) {
        this.portComponentLink = portComponentLink;
    }

    public String getServiceEndpointInterface() {
        return this.serviceEndpointInterface;
    }

    public void setServiceEndpointInterface(String serviceEndpointInterface) {
        this.serviceEndpointInterface = serviceEndpointInterface;
    }

    public QName getPortQName() {
        return this.portQName;
    }

    public void setPortQName(QName portQName) {
        this.portQName = portQName;
    }

    public List<UnifiedStubPropertyMetaData> getStubProperties() {
        return this.stubProperties;
    }

    public void setStubProperties(List<UnifiedStubPropertyMetaData> stubProps) {
        this.stubProperties = stubProps;
    }

    public void addStubProperty(UnifiedStubPropertyMetaData stubProp) {
        this.stubProperties.add(stubProp);
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public String getConfigName() {
        return this.configName;
    }

    public void setConfigName(String configName) {
        this.configName = configName;
    }

    public boolean matches(String seiName, QName portName) {
        if (seiName == null && portName == null) {
            throw Messages.MESSAGES.cannotMatchAgainstNull();
        }
        boolean match = false;
        if (portName != null) {
            match = portName.equals(this.getPortQName());
        }
        if (!match) {
            match = seiName.equals(this.getServiceEndpointInterface());
        }
        return match;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("\nUnifiedPortComponentRef");
        str.append("\n serviceEndpointInterface=" + this.serviceEndpointInterface);
        str.append("\n portQName=" + this.portQName);
        str.append("\n addressingAnnotationSpecified=" + this.addressingAnnotationSpecified);
        str.append("\n addressingEnabled=" + this.addressingEnabled);
        str.append("\n addressingRequired=" + this.addressingRequired);
        str.append("\n addressingResponses=" + this.addressingResponses);
        str.append("\n mtomEnabled=" + this.mtomEnabled);
        str.append("\n mtomThreshold=" + this.mtomThreshold);
        str.append("\n respectBindingAnnotationSpecified=" + this.respectBindingAnnotationSpecified);
        str.append("\n respectBindingEnabled=" + this.respectBindingEnabled);
        str.append("\n portComponentLink=" + this.portComponentLink);
        str.append("\n stubProperties=" + this.stubProperties);
        str.append("\n configName=" + this.configName);
        str.append("\n configFile=" + this.configFile);
        return str.toString();
    }
}

