/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.metadata.webservices;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.WebServiceException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.webservices.JBossWebservicesMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebservicesFactory;
import org.jboss.wsf.spi.util.StAXUtils;

public class JBossWebservicesFactory
extends WebservicesFactory {
    private static final ResourceBundle bundle = BundleUtils.getBundle(JBossWebservicesFactory.class);

    public JBossWebservicesFactory(URL descriptorURL) {
        super(descriptorURL);
    }

    public static JBossWebservicesMetaData loadFromVFSRoot(UnifiedVirtualFile root) {
        JBossWebservicesMetaData webservices = null;
        UnifiedVirtualFile wsdd = null;
        try {
            wsdd = root.findChild("META-INF/jboss-webservices.xml");
        }
        catch (IOException e) {
            // empty catch block
        }
        if (null == wsdd) {
            try {
                wsdd = root.findChild("WEB-INF/jboss-webservices.xml");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (wsdd != null) {
            return JBossWebservicesFactory.load(wsdd.toURL());
        }
        return webservices;
    }

    public static JBossWebservicesMetaData load(URL wsddUrl) {
        InputStream is = null;
        try {
            is = wsddUrl.openStream();
            XMLStreamReader xmlr = StAXUtils.createXMLStreamReader(is);
            JBossWebservicesMetaData jBossWebservicesMetaData = JBossWebservicesFactory.parse(xmlr, wsddUrl);
            return jBossWebservicesMetaData;
        }
        catch (Exception e) {
            throw new WebServiceException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"FAILED_TO_UNMARSHALL", (Object[])new Object[]{wsddUrl}), (Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public static JBossWebservicesMetaData parse(InputStream is) {
        return JBossWebservicesFactory.parse(is, null);
    }

    public static JBossWebservicesMetaData parse(InputStream is, URL descriptorURL) {
        try {
            XMLStreamReader xmlr = StAXUtils.createXMLStreamReader(is);
            return JBossWebservicesFactory.parse(xmlr, descriptorURL);
        }
        catch (Exception e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    public static JBossWebservicesMetaData parse(XMLStreamReader reader) throws XMLStreamException {
        return JBossWebservicesFactory.parse(reader, null);
    }

    private static JBossWebservicesMetaData parse(XMLStreamReader reader, URL descriptorURL) throws XMLStreamException {
        int iterate;
        try {
            iterate = reader.nextTag();
        }
        catch (XMLStreamException e) {
            iterate = reader.nextTag();
        }
        JBossWebservicesMetaData metadata = null;
        switch (iterate) {
            case 2: {
                break;
            }
            case 1: {
                if (StAXUtils.match(reader, "http://www.jboss.com/xml/ns/javaee", "webservices")) {
                    String nsUri = reader.getNamespaceURI();
                    JBossWebservicesFactory factory = new JBossWebservicesFactory(descriptorURL);
                    metadata = factory.parseWebservices(reader, nsUri, descriptorURL);
                    break;
                }
                throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNEXPECTED_ELEMENT", (Object[])new Object[]{reader.getLocalName()}));
            }
        }
        return metadata;
    }

    private JBossWebservicesMetaData parseWebservices(XMLStreamReader reader, String nsUri, URL descriptorURL) throws XMLStreamException {
        JBossWebservicesMetaData metadata = new JBossWebservicesMetaData(descriptorURL);
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (StAXUtils.match(reader, nsUri, "webservices")) {
                        return metadata;
                    }
                    throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNEXPECTED_END_TAG", (Object[])new Object[]{reader.getLocalName()}));
                }
                case 1: {
                    if (StAXUtils.match(reader, nsUri, "context-root")) {
                        metadata.setContextRoot(StAXUtils.elementAsString(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "config-name")) {
                        metadata.setConfigName(StAXUtils.elementAsString(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "config-file")) {
                        metadata.setConfigFile(StAXUtils.elementAsString(reader));
                        break;
                    }
                    if (StAXUtils.match(reader, nsUri, "webservice-description")) {
                        metadata.addWebserviceDescription(super.parseWebserviceDescription(reader, nsUri, metadata));
                        break;
                    }
                    throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNEXPECTED_ELEMENT", (Object[])new Object[]{reader.getLocalName()}));
                }
            }
        }
        throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"REACHED_END_OF_XML_DOCUMENT_UNEXPECTEDLY", (Object[])new Object[0]));
    }
}

