/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.metadata.j2ee.serviceref;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.jboss.logging.Logger;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.deployment.WritableUnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedCallPropertyMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainsMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaData;
import org.jboss.wsf.spi.serviceref.ServiceRefElement;
import org.jboss.wsf.spi.util.URLLoaderAdapter;

public final class UnifiedServiceRefMetaData
extends ServiceRefElement {
    private static final long serialVersionUID = -926464174132493955L;
    private static Logger log = Logger.getLogger(UnifiedServiceRefMetaData.class);
    private transient UnifiedVirtualFile vfsRoot;
    private String serviceRefName;
    private String serviceInterface;
    private String serviceRefType;
    private String wsdlFile;
    private String mappingFile;
    private QName serviceQName;
    private List<UnifiedPortComponentRefMetaData> portComponentRefs = new ArrayList<UnifiedPortComponentRefMetaData>();
    private List<UnifiedHandlerMetaData> handlers = new ArrayList<UnifiedHandlerMetaData>();
    private UnifiedHandlerChainsMetaData handlerChains;
    private String serviceImplClass;
    private String configName;
    private String configFile;
    private String wsdlOverride;
    private String handlerChain;
    private List<UnifiedCallPropertyMetaData> callProperties = new ArrayList<UnifiedCallPropertyMetaData>();
    private boolean addressingEnabled;
    private boolean addressingRequired;
    private String addressingResponses = "ALL";
    private boolean mtomEnabled;
    private int mtomThreshold;
    private boolean respectBindingEnabled;

    public UnifiedServiceRefMetaData(UnifiedVirtualFile vfRoot) {
        this.vfsRoot = vfRoot;
    }

    public UnifiedServiceRefMetaData() {
    }

    public void setAddressingEnabled(boolean addressingEnabled) {
        this.addressingEnabled = addressingEnabled;
    }

    public boolean isAddressingEnabled() {
        return this.addressingEnabled;
    }

    public void setAddressingRequired(boolean addressingRequired) {
        this.addressingRequired = addressingRequired;
    }

    public boolean isAddressingRequired() {
        return this.addressingRequired;
    }

    public void setAddressingResponses(String responsesTypes) {
        if (!("ANONYMOUS".equals(responsesTypes) || "NON_ANONYMOUS".equals(responsesTypes) || "ALL".equals(responsesTypes))) {
            throw new IllegalArgumentException("Only ALL, ANONYMOUS or NON_ANONYMOUS strings are allowed");
        }
        this.addressingResponses = responsesTypes;
    }

    public String getAddressingResponses() {
        return this.addressingResponses;
    }

    public void setMtomEnabled(boolean mtomEnabled) {
        this.mtomEnabled = mtomEnabled;
    }

    public boolean isMtomEnabled() {
        return this.mtomEnabled;
    }

    public void setMtomThreshold(int mtomThreshold) {
        this.mtomThreshold = mtomThreshold;
    }

    public int getMtomThreshold() {
        return this.mtomThreshold;
    }

    public void setRespectBindingEnabled(boolean respectBindingEnabled) {
        this.respectBindingEnabled = respectBindingEnabled;
    }

    public boolean isRespectBindingEnabled() {
        return this.respectBindingEnabled;
    }

    public UnifiedVirtualFile getVfsRoot() {
        return this.vfsRoot;
    }

    public void setVfsRoot(UnifiedVirtualFile vfsRoot) {
        this.vfsRoot = vfsRoot;
    }

    public String getServiceRefName() {
        return this.serviceRefName;
    }

    public void setServiceRefName(String serviceRefName) {
        this.serviceRefName = serviceRefName;
    }

    public String getMappingFile() {
        return this.mappingFile;
    }

    public void setMappingFile(String mappingFile) {
        this.mappingFile = mappingFile;
    }

    public URL getMappingLocation() {
        URL mappingURL = null;
        if (this.mappingFile != null) {
            try {
                mappingURL = this.vfsRoot.findChild(this.mappingFile).toURL();
            }
            catch (Exception e) {
                throw new WebServiceException("Cannot find jaxrcp-mapping-file: " + this.mappingFile, (Throwable)e);
            }
        }
        return mappingURL;
    }

    public Collection<UnifiedPortComponentRefMetaData> getPortComponentRefs() {
        return this.portComponentRefs;
    }

    public UnifiedPortComponentRefMetaData getPortComponentRef(String seiName, QName portName) {
        UnifiedPortComponentRefMetaData matchingRef = null;
        for (UnifiedPortComponentRefMetaData ref : this.portComponentRefs) {
            if (!ref.matches(seiName, portName)) continue;
            if (matchingRef != null) {
                log.warn((Object)("Multiple matching port component ref: [sei=" + seiName + ",port=" + portName + "]"));
            }
            matchingRef = ref;
        }
        return matchingRef;
    }

    public void addPortComponentRef(UnifiedPortComponentRefMetaData pcRef) {
        this.portComponentRefs.add(pcRef);
    }

    public List<UnifiedHandlerMetaData> getHandlers() {
        return this.handlers;
    }

    public void addHandler(UnifiedHandlerMetaData handler) {
        this.handlers.add(handler);
    }

    public String getServiceInterface() {
        return this.serviceInterface;
    }

    public void setServiceInterface(String serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public String getServiceImplClass() {
        return this.serviceImplClass;
    }

    public void setServiceImplClass(String serviceImplClass) {
        this.serviceImplClass = serviceImplClass;
    }

    public QName getServiceQName() {
        return this.serviceQName;
    }

    public void setServiceQName(QName serviceQName) {
        this.serviceQName = serviceQName;
    }

    public String getServiceRefType() {
        return this.serviceRefType;
    }

    public void setServiceRefType(String serviceResType) {
        this.serviceRefType = serviceResType;
    }

    public String getWsdlFile() {
        return this.wsdlFile;
    }

    public void setWsdlFile(String wsdlFile) {
        this.wsdlFile = wsdlFile;
    }

    public URL getWsdlLocation() {
        URL wsdlLocation = null;
        if (this.wsdlOverride != null) {
            try {
                wsdlLocation = new URL(this.wsdlOverride);
            }
            catch (MalformedURLException e1) {
                try {
                    wsdlLocation = this.vfsRoot.findChild(this.wsdlOverride).toURL();
                }
                catch (Exception e) {
                    throw new WebServiceException("Cannot find wsdl-override: " + this.wsdlOverride, (Throwable)e);
                }
            }
        }
        if (wsdlLocation == null && this.wsdlFile != null) {
            try {
                wsdlLocation = new URL(this.wsdlFile);
            }
            catch (MalformedURLException e1) {
                try {
                    wsdlLocation = this.vfsRoot.findChild(this.wsdlFile).toURL();
                }
                catch (Exception e) {
                    throw new WebServiceException("Cannot find wsdl-file: " + this.wsdlFile, (Throwable)e);
                }
            }
        }
        return wsdlLocation;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public String getConfigName() {
        return this.configName;
    }

    public void setConfigName(String configName) {
        this.configName = configName;
    }

    public String getWsdlOverride() {
        return this.wsdlOverride;
    }

    public void setWsdlOverride(String wsdlOverride) {
        this.wsdlOverride = wsdlOverride;
    }

    public List<UnifiedCallPropertyMetaData> getCallProperties() {
        return this.callProperties;
    }

    public void setCallProperties(List<UnifiedCallPropertyMetaData> callProps) {
        this.callProperties = callProps;
    }

    public void addCallProperty(UnifiedCallPropertyMetaData callProp) {
        this.callProperties.add(callProp);
    }

    public UnifiedHandlerChainsMetaData getHandlerChains() {
        return this.handlerChains;
    }

    public void setHandlerChains(UnifiedHandlerChainsMetaData handlerChains) {
        this.handlerChains = handlerChains;
    }

    public String getHandlerChain() {
        return this.handlerChain;
    }

    public void setHandlerChain(String handlerChain) {
        this.handlerChain = handlerChain;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.vfsRoot);
        if (this.vfsRoot instanceof WritableUnifiedVirtualFile) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ((WritableUnifiedVirtualFile)this.vfsRoot).writeContent(bos, new WritableUnifiedVirtualFile.NameFilter(){

                @Override
                public boolean accept(String fileName) {
                    boolean result = fileName.contains("META-INF");
                    result = result || fileName.endsWith(".wsdl");
                    result = result || fileName.endsWith(".xsd");
                    result = result || fileName.endsWith(".xml");
                    return result;
                }
            });
            out.writeObject(bos.toByteArray());
            out.writeObject(this.vfsRoot.getName());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        UnifiedVirtualFile obj = (UnifiedVirtualFile)in.readObject();
        if (obj.toURL() == null && obj instanceof WritableUnifiedVirtualFile) {
            byte[] bytes = (byte[])in.readObject();
            String vfName = (String)in.readObject();
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            File tempFile = File.createTempFile("jbossws-vf-", "-" + vfName);
            tempFile.deleteOnExit();
            FileOutputStream fos = new FileOutputStream(tempFile);
            UnifiedServiceRefMetaData.copyStreamAndClose(fos, bis);
            this.vfsRoot = new URLLoaderAdapter(tempFile.toURI().toURL());
        } else {
            this.vfsRoot = obj;
        }
    }

    private static void copyStreamAndClose(OutputStream outs, InputStream ins) throws IOException {
        try {
            byte[] bytes = new byte[1024];
            int r = ins.read(bytes);
            while (r > 0) {
                outs.write(bytes, 0, r);
                r = ins.read(bytes);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                ins.close();
            }
            catch (Exception e) {}
            try {
                outs.close();
            }
            catch (Exception e) {}
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("\nUnifiedServiceRef");
        str.append("\n serviceRefName=" + this.serviceRefName);
        str.append("\n serviceInterface=" + this.serviceInterface);
        str.append("\n serviceImplClass=" + this.serviceImplClass);
        str.append("\n serviceRefType=" + this.serviceRefType);
        str.append("\n serviceQName=" + this.serviceQName);
        str.append("\n wsdlFile=" + this.wsdlFile);
        str.append("\n wsdlOverride=" + this.wsdlOverride);
        str.append("\n mappingFile=" + this.mappingFile);
        str.append("\n configName=" + this.configName);
        str.append("\n configFile=" + this.configFile);
        str.append("\n callProperties=" + this.callProperties);
        str.append("\n addressingEnabled=" + this.addressingEnabled);
        str.append("\n addressingRequired=" + this.addressingRequired);
        str.append("\n addressingResponses=" + this.addressingResponses);
        str.append("\n mtomEnabled=" + this.mtomEnabled);
        str.append("\n mtomThreshold=" + this.mtomThreshold);
        str.append("\n respectBindingEnabled=" + this.respectBindingEnabled);
        str.append("\n handlerChains=" + this.handlerChains);
        str.append("\n handlerChain=" + this.handlerChain);
        for (UnifiedHandlerMetaData uhmd : this.handlers) {
            str.append(uhmd.toString());
        }
        for (UnifiedPortComponentRefMetaData pcref : this.portComponentRefs) {
            str.append(pcref.toString());
        }
        return str.toString();
    }
}

