/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.util;

import java.lang.ref.WeakReference;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;

public class ModuleClassLoaderProvider
extends ClassLoaderProvider {
    private static final ModuleIdentifier ASIL = ModuleIdentifier.create((String)"org.jboss.as.webservices.server.integration");
    private WeakReference<ClassLoader> integrationClassLoader;
    private static final ModuleIdentifier JAXRPC_ASIL = ModuleIdentifier.create((String)"org.jboss.as.webservices.server.jaxrpc-integration");
    private WeakReference<ClassLoader> jaxrpcIntegrationClassLoader;

    public ClassLoader getWebServiceSubsystemClassLoader() {
        return ((Object)((Object)this)).getClass().getClassLoader();
    }

    public ClassLoader getServerIntegrationClassLoader() {
        if (this.integrationClassLoader == null || this.integrationClassLoader.get() == null) {
            try {
                Module module = Module.getBootModuleLoader().loadModule(ASIL);
                this.integrationClassLoader = new WeakReference<ModuleClassLoader>(module.getClassLoader());
            }
            catch (ModuleLoadException e) {
                throw new RuntimeException(e);
            }
        }
        return (ClassLoader)this.integrationClassLoader.get();
    }

    public ClassLoader getServerJAXRPCIntegrationClassLoader() {
        if (this.jaxrpcIntegrationClassLoader == null || this.jaxrpcIntegrationClassLoader.get() == null) {
            try {
                Module module = Module.getBootModuleLoader().loadModule(JAXRPC_ASIL);
                this.jaxrpcIntegrationClassLoader = new WeakReference<ModuleClassLoader>(module.getClassLoader());
            }
            catch (ModuleLoadException e) {
                throw new RuntimeException(e);
            }
        }
        return (ClassLoader)this.jaxrpcIntegrationClassLoader.get();
    }

    public static void register() {
        ClassLoaderProvider.setDefaultProvider((ClassLoaderProvider)new ModuleClassLoaderProvider());
    }
}

