/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.jws.WebService;
import javax.xml.ws.WebServiceProvider;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.as.webservices.metadata.WebServiceDeclaration;
import org.jboss.as.webservices.metadata.WebServiceDeployment;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.jboss.as.webservices.util.WSServices;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;
import org.jboss.metadata.common.jboss.WebserviceDescriptionMetaData;
import org.jboss.metadata.common.jboss.WebserviceDescriptionsMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.ServletMetaData;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public final class ASHelper {
    public static final String CONTAINER_NAME = "org.jboss.wsf.spi.invocation.ContainerName";
    private static final Logger LOGGER = Logger.getLogger(ASHelper.class);
    public static final DotName WEB_SERVICE_ANNOTATION = DotName.createSimple((String)WebService.class.getName());
    public static final DotName WEB_SERVICE_PROVIDER_ANNOTATION = DotName.createSimple((String)WebServiceProvider.class.getName());

    private ASHelper() {
    }

    public static boolean isWebServiceDeployment(DeploymentUnit unit) {
        return ASHelper.getOptionalAttachment(unit, WSAttachmentKeys.DEPLOYMENT_KEY) != null;
    }

    public static List<ServletMetaData> getJaxwsServlets(DeploymentUnit unit) {
        return ASHelper.getWebServiceServlets(unit, true);
    }

    public static List<ServletMetaData> getJaxrpcServlets(DeploymentUnit unit) {
        return ASHelper.getWebServiceServlets(unit, false);
    }

    public static List<WebServiceDeclaration> getJaxwsEjbs(DeploymentUnit unit) {
        WebServiceDeployment wsDeployment = ASHelper.getRequiredAttachment(unit, WSAttachmentKeys.WEBSERVICE_DEPLOYMENT_KEY);
        return Collections.unmodifiableList(wsDeployment.getServiceEndpoints());
    }

    public static String getEndpointName(ServletMetaData servletMD) {
        String endpointClass = servletMD.getServletClass();
        return endpointClass != null ? endpointClass.trim() : null;
    }

    public static ServletMetaData getServletForName(JBossWebMetaData jbossWebMD, String servletName) {
        for (JBossServletMetaData servlet : jbossWebMD.getServlets()) {
            if (!servlet.getName().equals(servletName)) continue;
            return servlet;
        }
        throw new IllegalStateException("Cannot find servlet for link: " + servletName);
    }

    public static <A> A getRequiredAttachment(DeploymentUnit unit, AttachmentKey<A> key) {
        Object value = unit.getAttachment(key);
        if (value == null) {
            LOGGER.error((Object)("Cannot find attachment in deployment unit: " + key));
            throw new IllegalStateException();
        }
        return (A)value;
    }

    public static <A> A getOptionalAttachment(DeploymentUnit unit, AttachmentKey<A> key) {
        return (A)unit.getAttachment(key);
    }

    public static boolean hasAttachment(DeploymentUnit unit, AttachmentKey<?> key) {
        return ASHelper.getOptionalAttachment(unit, key) != null;
    }

    public static WebserviceDescriptionMetaData getWebserviceDescriptionMetaData(WebserviceDescriptionsMetaData wsDescriptionsMD) {
        if (wsDescriptionsMD != null) {
            if (wsDescriptionsMD.size() > 1) {
                LOGGER.warn((Object)"Multiple <webservice-description> elements not supported");
            }
            if (wsDescriptionsMD.size() > 0) {
                return (WebserviceDescriptionMetaData)wsDescriptionsMD.iterator().next();
            }
        }
        return null;
    }

    private static List<ServletMetaData> getWebServiceServlets(DeploymentUnit unit, boolean jaxws) {
        JBossWebMetaData jbossWebMD = ASHelper.getJBossWebMetaData(unit);
        CompositeIndex compositeIndex = (CompositeIndex)ASHelper.getRequiredAttachment(unit, Attachments.COMPOSITE_ANNOTATION_INDEX);
        return ASHelper.selectWebServiceServlets(compositeIndex, jbossWebMD.getServlets(), jaxws);
    }

    public static <T extends ServletMetaData> List<ServletMetaData> selectWebServiceServlets(CompositeIndex index, Collection<T> smd, boolean jaxws) {
        if (smd == null) {
            return Collections.emptyList();
        }
        ArrayList<ServletMetaData> endpoints = new ArrayList<ServletMetaData>();
        for (ServletMetaData servletMD : smd) {
            boolean isJaxrpcEndpoint;
            boolean isWebServiceEndpoint = ASHelper.isWebserviceEndpoint(servletMD, index);
            boolean isJaxwsEndpoint = jaxws && isWebServiceEndpoint;
            boolean bl = isJaxrpcEndpoint = !jaxws && isWebServiceEndpoint;
            if (!isJaxwsEndpoint && !isJaxrpcEndpoint) continue;
            endpoints.add(servletMD);
        }
        return endpoints;
    }

    private static boolean isWebserviceEndpoint(ServletMetaData servletMD, CompositeIndex index) {
        String endpointClassName = ASHelper.getEndpointName(servletMD);
        if (ASHelper.isJSP(endpointClassName)) {
            return false;
        }
        DotName endpointDotName = DotName.createSimple((String)endpointClassName);
        ClassInfo endpointClassInfo = index.getClassByName(endpointDotName);
        if (endpointClassInfo != null) {
            if (endpointClassInfo.annotations().containsKey(WEB_SERVICE_ANNOTATION)) {
                return true;
            }
            if (endpointClassInfo.annotations().containsKey(WEB_SERVICE_PROVIDER_ANNOTATION)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isJSP(String endpointClassName) {
        return endpointClassName == null || endpointClassName.length() == 0;
    }

    public static JBossWebMetaData getJBossWebMetaData(DeploymentUnit unit) {
        WarMetaData warMetaData = (WarMetaData)ASHelper.getOptionalAttachment(unit, WarMetaData.ATTACHMENT_KEY);
        JBossWebMetaData result = null;
        if (warMetaData != null && (result = warMetaData.getMergedJBossWebMetaData()) == null) {
            result = warMetaData.getJbossWebMetaData();
        }
        return result;
    }

    public static List<AnnotationInstance> getAnnotations(DeploymentUnit unit, DotName annotation) {
        CompositeIndex compositeIndex = (CompositeIndex)ASHelper.getRequiredAttachment(unit, Attachments.COMPOSITE_ANNOTATION_INDEX);
        return compositeIndex.getAnnotations(annotation);
    }

    public static boolean isJaxrpcEjbDeployment(DeploymentUnit unit) {
        return false;
    }

    public static boolean isJaxrpcJseDeployment(DeploymentUnit unit) {
        boolean hasJBossWebMD;
        boolean hasWebservicesMD = ASHelper.hasAttachment(unit, WSAttachmentKeys.WEBSERVICES_METADATA_KEY);
        boolean bl = hasJBossWebMD = ASHelper.getJBossWebMetaData(unit) != null;
        if (hasWebservicesMD && hasJBossWebMD) {
            return ASHelper.getJaxrpcServlets(unit).size() > 0;
        }
        return false;
    }

    public static boolean isJaxwsEjbDeployment(DeploymentUnit unit) {
        return ASHelper.hasAttachment(unit, WSAttachmentKeys.WEBSERVICE_DEPLOYMENT_KEY);
    }

    public static boolean isJaxwsJseDeployment(DeploymentUnit unit) {
        boolean hasWarMetaData = ASHelper.hasAttachment(unit, WarMetaData.ATTACHMENT_KEY);
        if (hasWarMetaData) {
            return ASHelper.getJaxwsServlets(unit).size() > 0 || ASHelper.hasAttachment(unit, WSAttachmentKeys.JMS_ENDPOINT_METADATA_KEY);
        }
        return !ASHelper.hasAttachment(unit, WSAttachmentKeys.WEBSERVICE_DEPLOYMENT_KEY) && ASHelper.hasAttachment(unit, WSAttachmentKeys.JMS_ENDPOINT_METADATA_KEY);
    }

    public static <T> T getMSCService(ServiceName serviceName, Class<T> clazz) {
        ServiceController service = WSServices.getContainerRegistry().getService(serviceName);
        return (T)(service != null ? service.getValue() : null);
    }
}

