/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.service;

import javax.management.ObjectName;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.as.security.service.SecurityDomainService;
import org.jboss.as.webservices.security.SecurityDomainContextAdaptor;
import org.jboss.as.webservices.util.WSServices;
import org.jboss.logging.Logger;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.security.SecurityUtil;
import org.jboss.wsf.spi.deployment.Endpoint;

public final class EndpointService
implements Service<Endpoint> {
    private static final Logger log = Logger.getLogger(EndpointService.class);
    private final Endpoint endpoint;
    private ServiceName name;
    private final InjectedValue<SecurityDomainContext> securityDomainContextValue = new InjectedValue();

    private EndpointService(Endpoint endpoint) {
        this.endpoint = endpoint;
        ObjectName on = endpoint.getName();
        this.name = WSServices.ENDPOINT_SERVICE.append(new String[]{on.getKeyProperty("context")}).append(new String[]{on.getKeyProperty("endpoint")});
    }

    public Endpoint getValue() {
        return this.endpoint;
    }

    public ServiceName getName() {
        return this.name;
    }

    public void start(StartContext context) throws StartException {
        log.infof("Starting %s", (Object)this.name);
        this.endpoint.setSecurityDomainContext((org.jboss.wsf.spi.security.SecurityDomainContext)new SecurityDomainContextAdaptor((SecurityDomainContext)this.securityDomainContextValue.getValue()));
    }

    public void stop(StopContext context) {
        log.infof("Stopping %s", (Object)this.name);
        this.endpoint.setSecurityDomainContext(null);
    }

    public Injector<SecurityDomainContext> getSecurityDomainContextInjector() {
        return this.securityDomainContextValue;
    }

    public static void install(ServiceTarget serviceTarget, Endpoint endpoint) {
        EndpointService service = new EndpointService(endpoint);
        ServiceBuilder builder = serviceTarget.addService(service.getName(), (Service)service);
        builder.addDependency(ServiceBuilder.DependencyType.REQUIRED, SecurityDomainService.SERVICE_NAME.append(new String[]{EndpointService.getDeploymentSecurityDomainName(endpoint)}), SecurityDomainContext.class, service.getSecurityDomainContextInjector());
        builder.setInitialMode(ServiceController.Mode.ACTIVE);
        builder.install();
    }

    private static String getDeploymentSecurityDomainName(Endpoint ep) {
        JBossWebMetaData metadata = (JBossWebMetaData)ep.getService().getDeployment().getAttachment(JBossWebMetaData.class);
        String metaDataSecurityDomain = metadata != null ? metadata.getSecurityDomain() : null;
        return metaDataSecurityDomain == null ? "other" : SecurityUtil.unprefixSecurityDomain((String)metaDataSecurityDomain.trim());
    }
}

