/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.javaee.spec;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.jboss.metadata.javaee.spec.ResourceAuthorityType;
import org.jboss.metadata.javaee.spec.ResourceSharingScopeType;
import org.jboss.metadata.javaee.support.MergeableMappedMetaData;
import org.jboss.metadata.javaee.support.ResourceInjectionMetaDataWithDescriptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlType(name="resource-refType", propOrder={"descriptions", "resourceRefName", "type", "resAuth", "resSharingScope", "mappedName", "injectionTargets", "ignoreDependency", "jndiName", "resourceName", "resUrl"})
public class ResourceReferenceMetaData
extends ResourceInjectionMetaDataWithDescriptions
implements MergeableMappedMetaData<ResourceReferenceMetaData> {
    private static final long serialVersionUID = 1900675456507941940L;
    private String type;
    private ResourceAuthorityType authority;
    private ResourceSharingScopeType sharingScope;
    private String resourceName;
    private String resUrl;

    public String getResourceRefName() {
        return this.getName();
    }

    @XmlElement(name="res-ref-name")
    public void setResourceRefName(String resourceRefName) {
        this.setName(resourceRefName);
    }

    public String getType() {
        return this.type;
    }

    @XmlElement(name="res-type")
    public void setType(String type) {
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        this.type = type;
    }

    public ResourceAuthorityType getResAuth() {
        return this.authority;
    }

    public void setResAuth(ResourceAuthorityType authority) {
        if (authority == null) {
            throw new IllegalArgumentException("Null authority");
        }
        this.authority = authority;
    }

    public boolean isContainerAuth() {
        if (this.authority == null) {
            return false;
        }
        return this.authority == ResourceAuthorityType.Container;
    }

    public ResourceSharingScopeType getResSharingScope() {
        return this.sharingScope;
    }

    @XmlElement(name="res-sharing-scope")
    public void setResSharingScope(ResourceSharingScopeType sharingScope) {
        if (sharingScope == null) {
            throw new IllegalArgumentException("Null sharingScope");
        }
        this.sharingScope = sharingScope;
    }

    public boolean isShareable() {
        if (this.sharingScope == null) {
            return true;
        }
        return this.sharingScope == ResourceSharingScopeType.Shareable;
    }

    @Override
    public ResourceReferenceMetaData merge(ResourceReferenceMetaData original) {
        ResourceReferenceMetaData merged = new ResourceReferenceMetaData();
        merged.merge(this, original);
        return merged;
    }

    public void merge(ResourceReferenceMetaData override, ResourceReferenceMetaData original) {
        super.merge(override, original);
        if (override != null && override.type != null) {
            this.setType(override.type);
        } else if (original.type != null) {
            this.setType(original.type);
        }
        if (override != null && override.resourceName != null) {
            this.setResourceName(override.resourceName);
        } else if (original.resourceName != null) {
            this.setResourceName(original.resourceName);
        }
        if (override != null && override.authority != null) {
            this.setResAuth(override.authority);
        } else if (original.authority != null) {
            this.setResAuth(original.authority);
        }
        if (override != null && override.sharingScope != null) {
            this.setResSharingScope(override.sharingScope);
        } else if (original.sharingScope != null) {
            this.setResSharingScope(original.sharingScope);
        }
        if (override != null && override.resUrl != null) {
            this.setResUrl(override.resUrl);
        } else if (original.resUrl != null) {
            this.setResUrl(original.resUrl);
        }
    }

    public String getResourceName() {
        return this.resourceName;
    }

    @XmlElement(required=false)
    public void setResourceName(String resourceName) {
        if (resourceName == null) {
            throw new IllegalArgumentException("Null resourceName");
        }
        this.resourceName = resourceName;
    }

    public String getResUrl() {
        return this.resUrl;
    }

    @XmlElement(required=false)
    public void setResUrl(String resUrl) {
        if (resUrl == null) {
            throw new IllegalArgumentException("Null resUrl");
        }
        this.resUrl = resUrl;
    }

    @Override
    public String toString() {
        StringBuilder tmp = new StringBuilder("ResourceReferenceMetaData{");
        tmp.append("name=");
        tmp.append(this.getResourceRefName());
        tmp.append(",resource-name=");
        tmp.append(this.getResourceName());
        tmp.append(",res-auth=");
        tmp.append((Object)this.getResAuth());
        tmp.append(",res-sharing-scope=");
        tmp.append((Object)this.getResSharingScope());
        tmp.append(",res-url=");
        tmp.append(this.getResUrl());
        tmp.append(",ignore-dependecy=");
        tmp.append(super.isDependencyIgnored());
        tmp.append(",jndi-name=");
        tmp.append(super.getJndiName());
        tmp.append(",resolvoed-jndi-name=");
        tmp.append(super.getResolvedJndiName());
        tmp.append('}');
        return tmp.toString();
    }
}

