/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator.ejb;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.Collections;
import org.jboss.metadata.annotation.creator.AbstractComponentProcessor;
import org.jboss.metadata.annotation.creator.AbstractProcessor;
import org.jboss.metadata.annotation.creator.DeclareRolesProcessor;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.creator.ejb.DenyAllProcessor;
import org.jboss.metadata.annotation.creator.ejb.EjbNameThreadLocal;
import org.jboss.metadata.annotation.creator.ejb.InterceptorsProcessor;
import org.jboss.metadata.annotation.creator.ejb.PermitAllProcessor;
import org.jboss.metadata.annotation.creator.ejb.RolesAllowedProcessor;
import org.jboss.metadata.annotation.creator.ejb.RunAsProcessor;
import org.jboss.metadata.annotation.creator.ejb.TransactionAttributeClassProcessor;
import org.jboss.metadata.annotation.creator.ejb.TransactionAttributeMethodProcessor;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.ejb.spec.AssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.spec.EjbJar3xMetaData;
import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;
import org.jboss.metadata.ejb.spec.EnterpriseBeansMetaData;
import org.jboss.metadata.ejb.spec.ExcludeListMetaData;
import org.jboss.metadata.ejb.spec.InterceptorBindingsMetaData;
import org.jboss.metadata.ejb.spec.MethodPermissionsMetaData;
import org.jboss.metadata.javaee.spec.EnvironmentRefsGroupMetaData;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEnterpriseBeanProcessor<MD extends EnterpriseBeanMetaData>
extends AbstractComponentProcessor<MD>
implements Processor<EjbJar3xMetaData, Class<?>> {
    protected abstract MD create(Class<?> var1);

    protected AbstractEnterpriseBeanProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
        this.addTypeProcessor(new TransactionAttributeClassProcessor(finder));
        this.addMethodProcessor(new TransactionAttributeMethodProcessor(finder));
        this.addTypeProcessor(new RunAsProcessor(finder));
        this.addTypeProcessor(new DeclareRolesProcessor(finder));
        this.addMethodProcessor(new DenyAllProcessor(finder));
        this.addTypeProcessor(new RolesAllowedProcessor(finder));
        this.addMethodProcessor(new RolesAllowedProcessor(finder));
        this.addTypeProcessor(new PermitAllProcessor(finder));
        this.addMethodProcessor(new PermitAllProcessor(finder));
        this.addTypeProcessor(new InterceptorsProcessor(finder));
        this.addMethodProcessor(new InterceptorsProcessor(finder));
    }

    @Override
    public void process(EjbJar3xMetaData ejbJarMetaData, Class<?> beanClass) {
        SecurityRolesMetaData securityRoles;
        MD beanMetaData = this.create(beanClass);
        if (beanMetaData == null) {
            return;
        }
        EjbNameThreadLocal.ejbName.set(((EnterpriseBeanMetaData)beanMetaData).getEjbName());
        EnvironmentRefsGroupMetaData env = (EnvironmentRefsGroupMetaData)((EnterpriseBeanMetaData)beanMetaData).getJndiEnvironmentRefsGroup();
        if (env == null) {
            env = new EnvironmentRefsGroupMetaData();
            ((EnterpriseBeanMetaData)beanMetaData).setJndiEnvironmentRefsGroup(env);
        }
        super.process(env, beanClass);
        if (ejbJarMetaData.getEnterpriseBeans() == null) {
            ejbJarMetaData.setEnterpriseBeans(new EnterpriseBeansMetaData());
        }
        ejbJarMetaData.getEnterpriseBeans().add(beanMetaData);
        this.processClass(beanMetaData, beanClass);
        AssemblyDescriptorMetaData assembly = ejbJarMetaData.getAssemblyDescriptor();
        if (assembly == null) {
            assembly = new AssemblyDescriptorMetaData();
            ejbJarMetaData.setAssemblyDescriptor(assembly);
        }
        if ((securityRoles = assembly.getSecurityRoles()) == null) {
            securityRoles = new SecurityRolesMetaData();
            assembly.setSecurityRoles(securityRoles);
        }
        super.processClass(securityRoles, beanClass);
        ExcludeListMetaData excludes = assembly.getExcludeList();
        if (excludes == null) {
            excludes = new ExcludeListMetaData();
            assembly.setExcludeList(excludes);
        }
        super.processClass(excludes, beanClass);
        MethodPermissionsMetaData permissions = assembly.getMethodPermissions();
        if (permissions == null) {
            permissions = new MethodPermissionsMetaData();
            assembly.setMethodPermissions(permissions);
        }
        super.processClass(permissions, beanClass);
        InterceptorBindingsMetaData interceptors = assembly.getInterceptorBindings();
        if (interceptors == null) {
            interceptors = new InterceptorBindingsMetaData();
            assembly.setInterceptorBindings(interceptors);
        }
        super.processClass(interceptors, beanClass);
        EjbNameThreadLocal.ejbName.set(null);
    }

    @Override
    public abstract Collection<Class<? extends Annotation>> getAnnotationTypes();

    @Override
    public Collection<Class<? extends Annotation>> getProcessedAnnotations(AbstractProcessor.Scope scope) {
        if (scope == AbstractProcessor.Scope.TYPE) {
            return this.getAnnotationTypes();
        }
        return Collections.EMPTY_SET;
    }
}

