/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss50.transport;

import javax.xml.ws.WebServiceException;
import org.jboss.wsf.common.ResourceLoaderAdapter;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.WSFRuntime;
import org.jboss.wsf.spi.WSFRuntimeLocator;
import org.jboss.wsf.spi.deployment.AbstractExtensible;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentModelFactory;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.Service;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.http.HttpContext;
import org.jboss.wsf.spi.http.HttpContextFactory;
import org.jboss.wsf.spi.http.HttpServer;

public class WSFRuntimeDelegateHttpServer
extends AbstractExtensible
implements HttpServer {
    public void start() {
    }

    public HttpContext createContext(String contextRoot) {
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        HttpContext httpContext = ((HttpContextFactory)spiProvider.getSPI(HttpContextFactory.class)).newHttpContext((HttpServer)this, contextRoot);
        return httpContext;
    }

    public void publish(HttpContext context, javax.xml.ws.Endpoint endpoint) {
        Class implClass = this.getImplementorClass(endpoint);
        try {
            SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
            WSFRuntimeLocator locator = (WSFRuntimeLocator)spiProvider.getSPI(WSFRuntimeLocator.class);
            WSFRuntime runtime = locator.locateRuntime("EndpointAPIRuntime");
            DeploymentModelFactory depModelFactory = (DeploymentModelFactory)spiProvider.getSPI(DeploymentModelFactory.class);
            Deployment dep = depModelFactory.newDeployment("endpoint-deployment", implClass.getClassLoader());
            dep.setType(Deployment.DeploymentType.JAXWS_JSE);
            dep.setRuntimeClassLoader(dep.getInitialClassLoader());
            ((ArchiveDeployment)dep).setRootFile((UnifiedVirtualFile)new ResourceLoaderAdapter());
            Service service = dep.getService();
            service.setContextRoot(context.getContextRoot());
            Endpoint ep = depModelFactory.newEndpoint(implClass.getName());
            ep.setShortName(implClass.getName() + "-Endpoint");
            ep.setURLPattern("/*");
            service.addEndpoint(ep);
            runtime.create(dep);
            runtime.start(dep);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new WebServiceException((Throwable)ex);
        }
    }

    public void destroy(HttpContext context, javax.xml.ws.Endpoint endpoint) {
    }

    private Class getImplementorClass(javax.xml.ws.Endpoint endpoint) {
        Object implementor = endpoint.getImplementor();
        Class<?> implClass = implementor instanceof Class ? (Class<?>)implementor : implementor.getClass();
        return implClass;
    }
}

