/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss50.transport;

import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.management.ServerConfigFactory;
import org.jboss.wsf.spi.transport.HttpListenerRef;
import org.jboss.wsf.spi.transport.HttpSpec;
import org.jboss.wsf.spi.transport.ListenerRef;
import org.jboss.wsf.spi.transport.TransportManager;
import org.jboss.wsf.spi.transport.TransportSpec;

public class NoopHttpTransportManager
implements TransportManager {
    public ListenerRef createListener(Endpoint endpoint, TransportSpec transportSpec) {
        if (!(transportSpec instanceof HttpSpec)) {
            throw new IllegalArgumentException("Unknown TransportSpec " + transportSpec);
        }
        HttpSpec httpSpec = (HttpSpec)transportSpec;
        SPIProvider provider = SPIProviderResolver.getInstance().getProvider();
        ServerConfigFactory spi = (ServerConfigFactory)provider.getSPI(ServerConfigFactory.class);
        ServerConfig serverConfig = spi.getServerConfig();
        String host = serverConfig.getWebServiceHost();
        int port = serverConfig.getWebServicePort();
        String hostAndPort = host + (port > 0 ? ":" + port : "");
        try {
            String ctx = httpSpec.getWebContext();
            String pattern = httpSpec.getUrlPattern();
            HttpListenerRef ref = new HttpListenerRef(ctx, pattern, new URI("http://" + hostAndPort + ctx + pattern));
            return ref;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to create ListenerRef", e);
        }
    }

    public void destroyListener(ListenerRef ref) {
    }
}

