/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss50.transport;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.wsf.container.jboss50.transport.WebAppDeploymentFactory;
import org.jboss.wsf.container.jboss50.transport.WebAppGenerator;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.management.ServerConfigFactory;
import org.jboss.wsf.spi.transport.HttpListenerRef;
import org.jboss.wsf.spi.transport.HttpSpec;
import org.jboss.wsf.spi.transport.ListenerRef;
import org.jboss.wsf.spi.transport.TransportManager;
import org.jboss.wsf.spi.transport.TransportSpec;

public class EJBHttpTransportManager
implements TransportManager {
    private static Logger log = Logger.getLogger(EJBHttpTransportManager.class);
    private static final String PROCESSED_BY_DEPLOYMENT_FACTORY = "processed.by.deployment.factory";
    private WebAppDeploymentFactory deploymentFactory;
    private WebAppGenerator generator;
    private Map<String, Deployment> deploymentRegistry = new HashMap<String, Deployment>();

    public ListenerRef createListener(Endpoint endpoint, TransportSpec transportSpec) {
        assert (this.deploymentFactory != null);
        assert (this.generator != null);
        if (!(transportSpec instanceof HttpSpec)) {
            throw new IllegalArgumentException("Unknown TransportSpec " + transportSpec);
        }
        HttpSpec httpSpec = (HttpSpec)transportSpec;
        Deployment topLevelDeployment = endpoint.getService().getDeployment();
        topLevelDeployment.setProperty("org.jboss.ws.webapp.ServletClass", (Object)httpSpec.getServletClass());
        topLevelDeployment.setProperty("org.jboss.ws.webapp.ContextParameterMap", (Object)httpSpec.getContextParameter());
        Boolean alreadyDeployed = (Boolean)topLevelDeployment.getProperty(PROCESSED_BY_DEPLOYMENT_FACTORY);
        if (alreadyDeployed == null || !alreadyDeployed.booleanValue()) {
            URL webAppURL = this.generator.create(topLevelDeployment);
            this.deploymentFactory.create(topLevelDeployment, webAppURL);
            topLevelDeployment.setProperty(PROCESSED_BY_DEPLOYMENT_FACTORY, (Object)Boolean.TRUE);
        }
        SPIProvider provider = SPIProviderResolver.getInstance().getProvider();
        ServerConfigFactory spi = (ServerConfigFactory)provider.getSPI(ServerConfigFactory.class);
        ServerConfig serverConfig = spi.getServerConfig();
        String host = serverConfig.getWebServiceHost();
        int port = serverConfig.getWebServicePort();
        String hostAndPort = host + (port > 0 ? ":" + port : "");
        HttpListenerRef listenerRef = null;
        try {
            String ctx = httpSpec.getWebContext();
            String pattern = httpSpec.getUrlPattern();
            listenerRef = new HttpListenerRef(ctx, pattern, new URI("http://" + hostAndPort + ctx + pattern));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to create ListenerRef", e);
        }
        this.deploymentRegistry.put(listenerRef.getUUID(), topLevelDeployment);
        return listenerRef;
    }

    public void destroyListener(ListenerRef ref) {
        Boolean alreadyDeployed;
        Deployment dep = this.deploymentRegistry.get(ref.getUUID());
        if (dep != null && (alreadyDeployed = (Boolean)dep.getProperty(PROCESSED_BY_DEPLOYMENT_FACTORY)) != null && alreadyDeployed.booleanValue()) {
            try {
                this.deploymentFactory.destroy(dep);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            dep.removeProperty(PROCESSED_BY_DEPLOYMENT_FACTORY);
        }
        this.deploymentRegistry.remove(ref.getUUID());
    }

    public void setDeploymentFactory(WebAppDeploymentFactory deploymentFactory) {
        this.deploymentFactory = deploymentFactory;
    }

    public void setGenerator(WebAppGenerator generator) {
        this.generator = generator;
    }
}

