/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss50.deployment.tomcat;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.ListenerMetaData;
import org.jboss.metadata.web.spec.ServletMetaData;
import org.jboss.wsf.spi.WSFRuntime;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyWebMetaDataDeploymentAspect
extends DeploymentAspect {
    public void create(Deployment dep, WSFRuntime runtime) {
        Map contextParams;
        String servletClass = (String)dep.getProperty("org.jboss.ws.webapp.ServletClass");
        if (servletClass == null) {
            throw new IllegalStateException("Cannot obtain context property: org.jboss.ws.webapp.ServletClass");
        }
        this.modifyServletClass(dep, servletClass);
        String listenerClass = (String)dep.getProperty("org.jboss.ws.webapp.ServletContextListener");
        if (listenerClass != null) {
            this.modifyListener(dep, listenerClass);
        }
        if ((contextParams = (Map)dep.getProperty("org.jboss.ws.webapp.ContextParameterMap")) != null) {
            this.modifyContextParams(dep, contextParams);
        }
    }

    private void modifyServletClass(Deployment dep, String servletClass) {
        JBossWebMetaData webMetaData = (JBossWebMetaData)dep.getAttachment(JBossWebMetaData.class);
        if (webMetaData != null) {
            for (JBossServletMetaData servlet : webMetaData.getServlets()) {
                String endpointClass = servlet.getServletClass();
                if (endpointClass == null || endpointClass.length() == 0) {
                    this.log.debug((Object)("Ignore servlet class: " + endpointClass));
                    continue;
                }
                if (this.isAlreadyModified((ServletMetaData)servlet) || this.isJavaxServlet(endpointClass, dep.getInitialClassLoader())) continue;
                servlet.setServletClass(servletClass);
                ParamValueMetaData initParam = new ParamValueMetaData();
                initParam.setParamName("jboss.ws.endpoint");
                initParam.setParamValue(endpointClass);
                ArrayList<ParamValueMetaData> initParams = servlet.getInitParam();
                if (initParams == null) {
                    initParams = new ArrayList<ParamValueMetaData>();
                    servlet.setInitParam(initParams);
                }
                initParams.add(initParam);
            }
        }
    }

    private void modifyListener(Deployment dep, String listenerClass) {
        JBossWebMetaData webMetaData = (JBossWebMetaData)dep.getAttachment(JBossWebMetaData.class);
        if (webMetaData != null) {
            ListenerMetaData listener = new ListenerMetaData();
            listener.setListenerClass(listenerClass);
            ArrayList<ListenerMetaData> listeners = webMetaData.getListeners();
            if (listeners == null) {
                listeners = new ArrayList<ListenerMetaData>();
                webMetaData.setListeners(listeners);
            }
            listeners.add(listener);
        }
    }

    private void modifyContextParams(Deployment dep, Map<String, String> newParams) {
        JBossWebMetaData webMetaData = (JBossWebMetaData)dep.getAttachment(JBossWebMetaData.class);
        if (webMetaData != null) {
            for (Map.Entry<String, String> entry : newParams.entrySet()) {
                ParamValueMetaData ctxParam = new ParamValueMetaData();
                ctxParam.setParamName(entry.getKey());
                ctxParam.setParamValue(entry.getValue());
                ArrayList<ParamValueMetaData> contextParams = webMetaData.getContextParams();
                if (contextParams == null) {
                    contextParams = new ArrayList<ParamValueMetaData>();
                    webMetaData.setContextParams(contextParams);
                }
                contextParams.add(ctxParam);
            }
        }
    }

    private boolean isJavaxServlet(String orgServletClass, ClassLoader loader) {
        boolean isServlet = false;
        if (loader != null) {
            try {
                Class<?> servletClass = loader.loadClass(orgServletClass);
                isServlet = Servlet.class.isAssignableFrom(servletClass);
                if (isServlet) {
                    this.log.info((Object)("Ignore servlet: " + orgServletClass));
                }
            }
            catch (ClassNotFoundException e) {
                this.log.warn((Object)("Cannot load servlet class: " + orgServletClass));
            }
        }
        return isServlet;
    }

    private boolean isAlreadyModified(ServletMetaData servlet) {
        List initParams = servlet.getInitParam();
        if (initParams != null) {
            for (ParamValueMetaData param : initParams) {
                if (!"jboss.ws.endpoint".equals(param.getParamName())) continue;
                return true;
            }
        }
        return false;
    }
}

