/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss50.deployer;

import javax.jws.WebService;
import javax.xml.ws.WebServiceProvider;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.mdb.MessagingContainer;
import org.jboss.ejb3.stateless.StatelessContainer;
import org.jboss.metadata.serviceref.VirtualFileAdaptor;
import org.jboss.wsf.container.jboss50.deployer.AbstractDeployerHookEJB;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.Service;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;

public class JAXWSDeployerHookEJB3
extends AbstractDeployerHookEJB {
    public Deployment.DeploymentType getDeploymentType() {
        return Deployment.DeploymentType.JAXWS_EJB3;
    }

    public Deployment createDeployment(DeploymentUnit unit) {
        ArchiveDeployment dep = this.newDeployment(unit);
        dep.setRootFile((UnifiedVirtualFile)new VirtualFileAdaptor(((VFSDeploymentUnit)unit).getRoot()));
        dep.setRuntimeClassLoader(unit.getClassLoader());
        dep.setType(this.getDeploymentType());
        Service service = dep.getService();
        Ejb3Deployment ejb3Deployment = (Ejb3Deployment)unit.getAttachment(Ejb3Deployment.class);
        if (ejb3Deployment == null) {
            throw new IllegalStateException("Deployment unit does not contain ejb3 deployment");
        }
        dep.addAttachment(Ejb3Deployment.class, (Object)ejb3Deployment);
        for (EJBContainer container : ejb3Deployment.getEjbContainers().values()) {
            if (!this.isWebServiceBean(container)) continue;
            String ejbName = container.getEjbName();
            String epBean = container.getBeanClassName();
            Endpoint ep = this.newEndpoint(epBean);
            ep.setShortName(ejbName);
            service.addEndpoint(ep);
        }
        return dep;
    }

    public boolean isWebServiceDeployment(DeploymentUnit unit) {
        Ejb3Deployment ejb3Deployment = (Ejb3Deployment)unit.getAttachment(Ejb3Deployment.class);
        if (ejb3Deployment == null) {
            return false;
        }
        boolean isWebServiceDeployment = false;
        for (EJBContainer container : ejb3Deployment.getEjbContainers().values()) {
            if (!this.isWebServiceBean(container)) continue;
            isWebServiceDeployment = true;
            break;
        }
        return isWebServiceDeployment;
    }

    private boolean isWebServiceBean(EJBContainer container) {
        boolean isWebServiceBean = false;
        if (container instanceof StatelessContainer || container instanceof MessagingContainer) {
            boolean isWebService = container.resolveAnnotation(WebService.class) != null;
            boolean isWebServiceProvider = container.resolveAnnotation(WebServiceProvider.class) != null;
            isWebServiceBean = isWebService || isWebServiceProvider;
        }
        return isWebServiceBean;
    }
}

