/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservices.integration.endpoint;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.ws.Endpoint;
import org.jboss.deployers.client.plugins.deployment.AbstractDeployment;
import org.jboss.deployers.client.spi.DeployerClient;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.client.spi.DeploymentFactory;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.attachments.MutableAttachments;
import org.jboss.deployers.spi.attachments.PredeterminedManagedObjectAttachments;
import org.jboss.deployers.structure.spi.ClassLoaderFactory;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.metadata.web.jboss.JBossServletsMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.ServletMappingMetaData;
import org.jboss.webservices.integration.util.WebMetaDataHelper;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.AbstractExtensible;
import org.jboss.wsf.spi.deployment.WSFDeploymentException;
import org.jboss.wsf.spi.http.HttpContext;
import org.jboss.wsf.spi.http.HttpContextFactory;
import org.jboss.wsf.spi.http.HttpServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EndpointAPIHttpServer
extends AbstractExtensible
implements HttpServer {
    private final DeploymentFactory factory = new DeploymentFactory();
    private final DeployerClient mainDeployer;
    private final SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
    private final Map<String, Deployment> deployments = new HashMap<String, Deployment>();

    public EndpointAPIHttpServer(DeployerClient mainDeployer) {
        this.mainDeployer = mainDeployer;
    }

    public synchronized HttpContext createContext(String contextRoot) {
        return ((HttpContextFactory)this.spiProvider.getSPI(HttpContextFactory.class)).newHttpContext((HttpServer)this, contextRoot);
    }

    public synchronized void publish(HttpContext context, Endpoint endpoint) {
        String contextRoot = context.getContextRoot();
        if (this.deployments.keySet().contains(contextRoot)) {
            throw new WSFDeploymentException("Context root '" + contextRoot + "' already exists");
        }
        Class<?> endpointClass = this.getEndpointClass(endpoint);
        ClassLoader endpointClassLoader = endpointClass.getClassLoader();
        Deployment deployment = this.createSimpleDeployment("http://jaxws-endpoint-api" + contextRoot);
        MutableAttachments mutableAttachments = (MutableAttachments)deployment.getPredeterminedManagedObjects();
        JBossWebMetaData jbossWebMD = this.newJBossWebMetaData(contextRoot, endpointClass);
        mutableAttachments.addAttachment("org.jboss.web.explicitDocBase", (Object)"/", String.class);
        mutableAttachments.addAttachment(JBossWebMetaData.class, (Object)jbossWebMD);
        mutableAttachments.addAttachment(ClassLoaderFactory.class, (Object)new ContextClassLoaderFactory(endpointClassLoader));
        try {
            this.mainDeployer.deploy(new Deployment[]{deployment});
            this.deployments.put(contextRoot, deployment);
        }
        catch (DeploymentException de) {
            WSFDeploymentException.rethrow((Throwable)de);
        }
    }

    public synchronized void destroy(HttpContext context, Endpoint endpoint) {
        try {
            String contextRoot = context.getContextRoot();
            Deployment deployment = this.deployments.remove(contextRoot);
            if (deployment != null) {
                this.mainDeployer.undeploy(new Deployment[]{deployment});
            }
        }
        catch (Exception ex) {
            WSFDeploymentException.rethrow((Throwable)ex);
        }
    }

    private Class<?> getEndpointClass(Endpoint endpoint) {
        Object implementor = endpoint.getImplementor();
        return implementor instanceof Class ? (Class<?>)implementor : implementor.getClass();
    }

    private JBossWebMetaData newJBossWebMetaData(String contextRoot, Class<?> endpointClass) {
        JBossWebMetaData jbossWebMD = new JBossWebMetaData();
        JBossServletsMetaData servletsMD = WebMetaDataHelper.getServlets(jbossWebMD);
        List<ServletMappingMetaData> servletMappingMD = WebMetaDataHelper.getServletMappings(jbossWebMD);
        String servletName = "jaxws-dynamic-endpoint";
        WebMetaDataHelper.newServlet("jaxws-dynamic-endpoint", endpointClass.getName(), servletsMD);
        WebMetaDataHelper.newServletMapping("jaxws-dynamic-endpoint", WebMetaDataHelper.getUrlPatterns("/*"), servletMappingMD);
        jbossWebMD.setContextRoot(contextRoot);
        return jbossWebMD;
    }

    private Deployment createSimpleDeployment(String name) {
        AbstractDeployment unit = new AbstractDeployment(name);
        this.factory.addContext((PredeterminedManagedObjectAttachments)unit, "");
        return unit;
    }

    private static class ContextClassLoaderFactory
    implements ClassLoaderFactory {
        private ClassLoader classLoader;

        public ContextClassLoaderFactory(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public ClassLoader createClassLoader(DeploymentUnit unit) throws Exception {
            return this.classLoader;
        }

        public void removeClassLoader(DeploymentUnit unit) throws Exception {
            this.classLoader = null;
        }
    }
}

