/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss50.deployment.metadata;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.jws.WebService;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.xml.ws.WebServiceProvider;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.javaee.spec.EnvironmentEntriesMetaData;
import org.jboss.metadata.javaee.spec.EnvironmentEntryMetaData;
import org.jboss.metadata.javaee.spec.ResourceInjectionTargetMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.wsf.common.injection.resolvers.ResourceReferenceResolver;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.integration.WebServiceDeclaration;
import org.jboss.wsf.spi.deployment.integration.WebServiceDeployment;
import org.jboss.wsf.spi.metadata.injection.InjectionMetaData;
import org.jboss.wsf.spi.metadata.injection.InjectionsMetaData;
import org.jboss.wsf.spi.metadata.injection.ReferenceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InjectionMetaDataDeploymentAspect
extends DeploymentAspect {
    private static final ReferenceResolver RESOURCE_REFERENCE_RESOLVER = new ResourceReferenceResolver();
    private static final String EJB3_JNDI_PREFIX = "java:env/";

    public void create(Deployment dep) {
        super.create(dep);
        DeploymentUnit unit = (DeploymentUnit)dep.getAttachment(DeploymentUnit.class);
        if (unit == null) {
            throw new IllegalStateException("DeploymentUnit not found");
        }
        JBossWebMetaData webMD = (JBossWebMetaData)dep.getAttachment(JBossWebMetaData.class);
        if (webMD == null) {
            throw new IllegalStateException("JBossWebMetaData not found");
        }
        LinkedList<InjectionMetaData> injectionMD = new LinkedList<InjectionMetaData>();
        Map<Class<? extends Annotation>, ReferenceResolver> resolvers = this.createResolvers(unit);
        Deployment.DeploymentType deploymentType = dep.getType();
        try {
            if (deploymentType == Deployment.DeploymentType.JAXWS_JSE) {
                injectionMD.addAll(this.buildInjectionMetaData(webMD.getEnvironmentEntries()));
                for (Endpoint endpoint : dep.getService().getEndpoints()) {
                    InjectionsMetaData injectionsMD = new InjectionsMetaData(injectionMD, resolvers, null);
                    endpoint.addAttachment(InjectionsMetaData.class, (Object)injectionsMD);
                }
            } else if (deploymentType == Deployment.DeploymentType.JAXWS_EJB3) {
                JBossMetaData jbossMD = (JBossMetaData)unit.getAttachment(JBossMetaData.class);
                JBossEnterpriseBeansMetaData jebMDs = jbossMD.getEnterpriseBeans();
                WebServiceDeployment webServiceDeployment = (WebServiceDeployment)unit.getAttachment(WebServiceDeployment.class);
                for (WebServiceDeclaration container : webServiceDeployment.getServiceEndpoints()) {
                    if (!this.isWebServiceBean(container)) continue;
                    Context ctx = (Context)container.getContext().lookup(EJB3_JNDI_PREFIX);
                    String ejbName = container.getComponentName();
                    EnvironmentEntriesMetaData ejbEnvEntries = ((JBossEnterpriseBeanMetaData)jebMDs.get(ejbName)).getEnvironmentEntries();
                    injectionMD.addAll(this.buildInjectionMetaData(ejbEnvEntries));
                    Endpoint endpoint = dep.getService().getEndpointByName(ejbName);
                    InjectionsMetaData injectionsMD = new InjectionsMetaData(injectionMD, resolvers, ctx);
                    endpoint.addAttachment(InjectionsMetaData.class, (Object)injectionsMD);
                }
            }
        }
        catch (NamingException ne) {
            throw new RuntimeException(ne);
        }
    }

    public void destroy(Deployment dep) {
        dep.getService().removeAttachment(InjectionMetaData.class);
        super.destroy(dep);
    }

    private Map<Class<? extends Annotation>, ReferenceResolver> createResolvers(DeploymentUnit unit) {
        HashMap<Class<? extends Annotation>, ReferenceResolver> resolvers = new HashMap<Class<? extends Annotation>, ReferenceResolver>();
        resolvers.put(Resource.class, RESOURCE_REFERENCE_RESOLVER);
        return resolvers;
    }

    private List<InjectionMetaData> buildInjectionMetaData(EnvironmentEntriesMetaData envEntries) {
        if (envEntries == null || envEntries.size() == 0) {
            return Collections.emptyList();
        }
        EnvironmentEntryMetaData eeMD2 = null;
        LinkedList<InjectionMetaData> retVal = new LinkedList<InjectionMetaData>();
        String envEntryName = null;
        String envEntryValue = null;
        String targetClass = null;
        String targetName = null;
        String valueClass = null;
        for (EnvironmentEntryMetaData eeMD2 : envEntries) {
            envEntryName = eeMD2.getEnvEntryName();
            envEntryValue = eeMD2.getValue();
            valueClass = eeMD2.getType();
            Set injectionTargets = eeMD2.getInjectionTargets();
            if (injectionTargets == null || injectionTargets.size() <= 0) continue;
            for (ResourceInjectionTargetMetaData ritMD : injectionTargets) {
                targetClass = ritMD.getInjectionTargetClass();
                targetName = ritMD.getInjectionTargetName();
                InjectionMetaData injectionMD = new InjectionMetaData(targetClass, targetName, valueClass, envEntryName, envEntryValue != null);
                retVal.add(injectionMD);
            }
        }
        return retVal;
    }

    private boolean isWebServiceBean(WebServiceDeclaration container) {
        boolean isWebService = container.getAnnotation(WebService.class) != null;
        boolean isWebServiceProvider = container.getAnnotation(WebServiceProvider.class) != null;
        return isWebService || isWebServiceProvider;
    }
}

