/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss42;

import org.jboss.wsf.spi.ComposableRuntime;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.WSFRuntime;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspectManager;
import org.jboss.wsf.spi.invocation.InvocationHandlerFactory;
import org.jboss.wsf.spi.invocation.RequestHandlerFactory;
import org.jboss.wsf.spi.management.EndpointRegistry;
import org.jboss.wsf.spi.transport.TransportManagerFactory;

public class LazyAssemblyWSFRuntime
implements WSFRuntime,
ComposableRuntime {
    private boolean assembled;
    private String runtimeName;
    private TransportManagerFactory tmf;
    private RequestHandlerFactory rhf;
    private InvocationHandlerFactory ihf;
    private DeploymentAspectManager dam;
    private EndpointRegistry reg;

    public void setRuntimeName(String runtimeName) {
        this.runtimeName = runtimeName;
    }

    public void create(Deployment deployment) {
        this.assemble();
        this.dam.create(deployment, (WSFRuntime)this);
    }

    public void start(Deployment deployment) {
        this.assemble();
        this.dam.start(deployment, (WSFRuntime)this);
    }

    public void stop(Deployment deployment) {
        this.assemble();
        this.dam.stop(deployment, (WSFRuntime)this);
    }

    public void destroy(Deployment deployment) {
        this.assemble();
        this.dam.destroy(deployment, (WSFRuntime)this);
    }

    public void setTransportManagerFactory(TransportManagerFactory factory) {
        this.tmf = factory;
    }

    public TransportManagerFactory getTransportManagerFactory() {
        return this.tmf;
    }

    public void setEndpointRegistry(EndpointRegistry endpointRegistry) {
        this.reg = endpointRegistry;
    }

    public EndpointRegistry getEndpointRegistry() {
        return this.reg;
    }

    public void setDeploymentAspectManager(DeploymentAspectManager deploymentManager) {
        this.dam = deploymentManager;
    }

    public DeploymentAspectManager getDeploymentAspectManager() {
        return this.dam;
    }

    public void setRequestHandlerFactory(RequestHandlerFactory factory) {
        this.rhf = factory;
    }

    public RequestHandlerFactory getRequestHandlerFactory() {
        return this.rhf;
    }

    public void setInvocationHandlerFactory(InvocationHandlerFactory factory) {
        this.ihf = factory;
    }

    public InvocationHandlerFactory getInvocationHandlerFactory() {
        return this.ihf;
    }

    private void assemble() {
        if (!this.assembled) {
            SPIProvider provider = SPIProviderResolver.getInstance().getProvider();
            RequestHandlerFactory rhFactory = (RequestHandlerFactory)provider.getSPI(RequestHandlerFactory.class);
            this.setRequestHandlerFactory(rhFactory);
            this.assembled = true;
        }
    }
}

