/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss42.serviceref;

import java.io.File;
import java.lang.reflect.AnnotatedElement;
import java.net.MalformedURLException;
import java.net.URL;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.xml.rpc.Service;
import org.jboss.logging.Logger;
import org.jboss.ws.integration.ServiceRefElement;
import org.jboss.ws.integration.ServiceRefHandler;
import org.jboss.ws.integration.ServiceRefMetaData;
import org.jboss.ws.integration.URLLoaderAdapter;
import org.jboss.ws.integration.UnifiedVirtualFile;
import org.jboss.wsf.container.jboss42.serviceref.DelegatingServiceRefMetaData;
import org.jboss.wsf.container.jboss42.serviceref.ServiceRefObjectFactory;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.WSFException;
import org.jboss.wsf.spi.serviceref.ServiceRefBinder;
import org.jboss.wsf.spi.serviceref.ServiceRefBinderFactory;
import org.jboss.wsf.spi.serviceref.ServiceRefHandler;
import org.jboss.xb.binding.UnmarshallingContext;
import org.xml.sax.Attributes;

public class ServiceRefHandlerImpl
implements ServiceRefHandler {
    private static Logger log = Logger.getLogger(ServiceRefHandlerImpl.class);
    private ServiceRefObjectFactory objectFactory = new ServiceRefObjectFactory();

    private ServiceRefBinder getJaxrpcBinder() {
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        return ((ServiceRefBinderFactory)spiProvider.getSPI(ServiceRefBinderFactory.class)).newServiceRefBinder(ServiceRefHandler.Type.JAXRPC);
    }

    private ServiceRefBinder getJaxwsBinder() {
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        return ((ServiceRefBinderFactory)spiProvider.getSPI(ServiceRefBinderFactory.class)).newServiceRefBinder(ServiceRefHandler.Type.JAXWS);
    }

    public ServiceRefMetaData newServiceRefMetaData() {
        return new DelegatingServiceRefMetaData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindServiceRef(Context encCtx, String encName, UnifiedVirtualFile vfsRoot, ClassLoader loader, ServiceRefMetaData sref) throws NamingException {
        String fileName;
        URLLoaderAdapter ula;
        URL rootURL;
        if (sref.isProcessed()) {
            log.debug((Object)("Attempt to rebind the service-ref: " + sref.getServiceRefName()));
            return;
        }
        if (vfsRoot instanceof URLLoaderAdapter && "file".equals((rootURL = (ula = (URLLoaderAdapter)vfsRoot).toURL()).getProtocol()) && rootURL.getFile().endsWith(".war") && !new File(fileName = rootURL.getFile()).exists()) {
            File expandedDirectory = new File(fileName = fileName.substring(0, fileName.indexOf(".war")) + "-exp.war");
            if (!expandedDirectory.exists()) {
                throw new WSFException("Failed to bind service-ref, the deployment root expandedDirectory doesn't exist: " + fileName);
            }
            try {
                vfsRoot = new URLLoaderAdapter(expandedDirectory.toURL());
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        DelegatingServiceRefMetaData serviceRef = (DelegatingServiceRefMetaData)sref;
        serviceRef.setVfsRoot(vfsRoot);
        try {
            if (this.getServiceRefType(serviceRef, loader) == ServiceRefHandler.Type.JAXRPC) {
                this.getJaxrpcBinder().setupServiceRef(encCtx, encName, null, serviceRef.delegate, loader);
            } else {
                AnnotatedElement anElement = (AnnotatedElement)sref.getAnnotatedElement();
                this.getJaxwsBinder().setupServiceRef(encCtx, encName, anElement, serviceRef.delegate, loader);
            }
        }
        finally {
            sref.setProcessed(true);
        }
    }

    public Object newChild(ServiceRefElement ref, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        return this.objectFactory.newChild(ref, navigator, namespaceURI, localName, attrs);
    }

    public void setValue(ServiceRefElement ref, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        this.objectFactory.setValue(ref, navigator, namespaceURI, localName, value);
    }

    private ServiceRefHandler.Type getServiceRefType(DelegatingServiceRefMetaData serviceRef, ClassLoader loader) throws NamingException {
        String serviceRefType = serviceRef.getServiceRefType();
        if (serviceRefType != null || serviceRef.getAnnotatedElement() != null) {
            return ServiceRefHandler.Type.JAXWS;
        }
        if (serviceRef.getMappingFile() != null) {
            return ServiceRefHandler.Type.JAXRPC;
        }
        String siName = serviceRef.getServiceInterface();
        if (siName == null) {
            throw new IllegalStateException("<service-interface> cannot be null");
        }
        if (siName.equals("javax.xml.rpc.Service")) {
            return ServiceRefHandler.Type.JAXRPC;
        }
        try {
            Class<?> siClass = loader.loadClass(siName);
            if (javax.xml.ws.Service.class.isAssignableFrom(siClass)) {
                return ServiceRefHandler.Type.JAXWS;
            }
            if (Service.class.isAssignableFrom(siClass)) {
                return ServiceRefHandler.Type.JAXRPC;
            }
            throw new IllegalStateException("Illegal service interface: " + siName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Cannot load <service-interface>: " + siName);
        }
    }
}

