/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.deployment;

import java.util.StringTokenizer;
import javax.jws.WebService;
import org.jboss.ws.Constants;
import org.jboss.wsf.common.integration.AbstractDeploymentAspect;
import org.jboss.wsf.spi.annotation.WebContext;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.metadata.j2ee.EJBArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.EJBMetaData;
import org.jboss.wsf.spi.metadata.j2ee.JSEArchiveMetaData;

public class URLPatternDeploymentAspect
extends AbstractDeploymentAspect {
    public void start(Deployment dep) {
        for (Endpoint ep : dep.getService().getEndpoints()) {
            String urlPattern = ep.getURLPattern();
            if (urlPattern != null) continue;
            urlPattern = this.getExplicitPattern(dep, ep);
            if (urlPattern == null) {
                urlPattern = this.getImplicitPattern(dep, ep);
            }
            if (!urlPattern.startsWith("/")) {
                urlPattern = "/" + urlPattern;
            }
            ep.setURLPattern(urlPattern);
        }
    }

    protected String getExplicitPattern(Deployment dep, Endpoint ep) {
        EJBMetaData bmd;
        EJBArchiveMetaData appMetaData;
        String urlPattern = null;
        JSEArchiveMetaData webMetaData = (JSEArchiveMetaData)dep.getAttachment(JSEArchiveMetaData.class);
        if (webMetaData != null) {
            String epName = ep.getShortName();
            urlPattern = (String)webMetaData.getServletMappings().get(epName);
            if (urlPattern == null) {
                throw new IllegalStateException("Cannot obtain servlet mapping for: " + epName);
            }
        }
        if ((appMetaData = (EJBArchiveMetaData)dep.getAttachment(EJBArchiveMetaData.class)) != null && appMetaData.getBeanByEjbName(ep.getShortName()) != null && (urlPattern = (bmd = appMetaData.getBeanByEjbName(ep.getShortName())).getPortComponentURI()) != null) {
            StringTokenizer st;
            String contextRoot = dep.getService().getContextRoot();
            if (!urlPattern.startsWith("/")) {
                urlPattern = "/" + urlPattern;
            }
            if ((st = new StringTokenizer(urlPattern, "/")).countTokens() > 1 && urlPattern.startsWith(contextRoot + "/")) {
                urlPattern = urlPattern.substring(contextRoot.length());
            }
        }
        if (urlPattern == null) {
            Class beanClass = ep.getTargetBeanClass();
            WebContext anWebContext = beanClass.getAnnotation(WebContext.class);
            if (anWebContext != null && anWebContext.urlPattern().length() > 0) {
                urlPattern = anWebContext.urlPattern();
            } else if (!Constants.BC_CONTEXT_MODE) {
                String name;
                WebService webServiceAnnotation = beanClass.getAnnotation(WebService.class);
                String string = name = webServiceAnnotation != null ? webServiceAnnotation.name() : null;
                if (name != null && name.length() > 0) {
                    urlPattern = name;
                } else {
                    String fullClassName = beanClass.getName();
                    urlPattern = fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
                }
            }
        }
        return urlPattern;
    }

    protected String getImplicitPattern(Deployment dep, Endpoint ep) {
        String urlPattern = ep.getShortName();
        return urlPattern;
    }
}

