/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.deployment;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.wsf.framework.deployment.DefaultDeployment;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveDeploymentImpl
extends DefaultDeployment
implements ArchiveDeployment {
    private ArchiveDeployment parent;
    private UnifiedVirtualFile rootFile;
    private static Logger log = Logger.getLogger(ArchiveDeploymentImpl.class);
    private List<UnifiedVirtualFile> metadataFiles;

    ArchiveDeploymentImpl(String simpleName, ClassLoader classLoader) {
        super(simpleName, classLoader);
    }

    public ArchiveDeployment getParent() {
        return this.parent;
    }

    public void setParent(ArchiveDeployment parent) {
        this.parent = parent;
    }

    public UnifiedVirtualFile getRootFile() {
        return this.rootFile;
    }

    public void setRootFile(UnifiedVirtualFile rootFile) {
        this.rootFile = rootFile;
    }

    public String getCanonicalName() {
        String name = this.getSimpleName();
        if (this.getParent() != null) {
            name = this.getParent().getCanonicalName() + "/" + name;
        }
        return name;
    }

    public URL getMetaDataFileURL(String resourcePath) throws IOException {
        URL resourceURL = null;
        if (resourcePath != null && resourcePath.length() > 0) {
            UnifiedVirtualFile vfResource;
            block15: {
                if (resourcePath.startsWith("/")) {
                    resourcePath = resourcePath.substring(1);
                }
                try {
                    resourceURL = new URL(resourcePath);
                }
                catch (MalformedURLException ex) {
                    // empty catch block
                }
                if (resourceURL == null && this.getRootFile() != null) {
                    try {
                        vfResource = this.getRootFile().findChild(resourcePath);
                        resourceURL = vfResource.toURL();
                    }
                    catch (IOException e) {
                        if (this.metadataFiles == null || this.metadataFiles.isEmpty()) {
                            throw e;
                        }
                        if (!log.isDebugEnabled()) break block15;
                        log.debug((Object)("Cannot get " + resourcePath + " from root file, trying with additional metadata files"), (Throwable)e);
                    }
                }
            }
            if (resourceURL == null && this.metadataFiles != null && !this.metadataFiles.isEmpty()) {
                vfResource = null;
                Iterator<UnifiedVirtualFile> it = this.getMetadataFiles().iterator();
                while (it.hasNext() && vfResource == null) {
                    UnifiedVirtualFile uvf = it.next();
                    URL wsdlUrl = uvf.toURL();
                    String wsdlPath = wsdlUrl.getPath();
                    if (wsdlPath.startsWith("/")) {
                        wsdlPath = wsdlPath.substring(1);
                    }
                    if (resourcePath.equals(wsdlPath)) {
                        vfResource = uvf;
                        continue;
                    }
                    try {
                        vfResource = uvf.findChild(resourcePath);
                    }
                    catch (IOException e) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Cannot get " + resourcePath + " from " + uvf), (Throwable)e);
                    }
                }
                if (vfResource == null) {
                    throw new IOException("Could not find " + resourcePath + " in the additional metadatafiles!");
                }
                resourceURL = vfResource.toURL();
            }
        }
        return resourceURL;
    }

    public List<UnifiedVirtualFile> getMetadataFiles() {
        return this.metadataFiles;
    }

    public void setMetadataFiles(List<UnifiedVirtualFile> metadataFiles) {
        this.metadataFiles = metadataFiles;
    }
}

