/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.deployment;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import org.jboss.logging.Logger;
import org.jboss.wsf.spi.deployment.ResourceResolver;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;

public class ResourceResolverImpl
implements ResourceResolver {
    private static Logger log = Logger.getLogger(ResourceResolverImpl.class);
    private UnifiedVirtualFile rootFile;
    private Collection<UnifiedVirtualFile> metadataFiles;

    public ResourceResolverImpl(UnifiedVirtualFile rootFile, Collection<UnifiedVirtualFile> metadataFiles) {
        this.rootFile = rootFile;
        this.metadataFiles = metadataFiles;
    }

    public URL resolve(String resourcePath) throws IOException {
        URL resourceURL = null;
        if (resourcePath != null && resourcePath.length() > 0) {
            UnifiedVirtualFile vfResource;
            block18: {
                if (resourcePath.startsWith("/")) {
                    resourcePath = resourcePath.substring(1);
                }
                try {
                    resourceURL = new URL(resourcePath);
                }
                catch (MalformedURLException ex) {
                    // empty catch block
                }
                if (resourceURL == null && this.rootFile != null) {
                    try {
                        vfResource = this.rootFile.findChild(resourcePath);
                        resourceURL = vfResource.toURL();
                    }
                    catch (IOException e) {
                        if (this.metadataFiles == null || this.metadataFiles.isEmpty()) {
                            throw e;
                        }
                        if (!log.isDebugEnabled()) break block18;
                        log.debug((Object)("Cannot get " + resourcePath + " from root file, trying with additional metadata files"), (Throwable)e);
                    }
                }
            }
            if (resourceURL == null && this.metadataFiles != null && !this.metadataFiles.isEmpty()) {
                vfResource = null;
                Iterator<UnifiedVirtualFile> it = this.metadataFiles.iterator();
                while (it.hasNext() && vfResource == null) {
                    UnifiedVirtualFile uvf = it.next();
                    URL wsdlUrl = uvf.toURL();
                    String wsdlPath = wsdlUrl.getPath();
                    if (wsdlPath.startsWith("/")) {
                        wsdlPath = wsdlPath.substring(1);
                    }
                    if (resourcePath.equals(wsdlPath)) {
                        vfResource = uvf;
                        continue;
                    }
                    try {
                        vfResource = uvf.findChild(resourcePath);
                    }
                    catch (IOException e) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Cannot get " + resourcePath + " from " + uvf), (Throwable)e);
                    }
                }
                if (resourceURL == null && resourcePath.startsWith("classpath:")) {
                    resourcePath = resourcePath.substring("classpath:".length());
                    ClassLoader cl = this.getClass().getClassLoader();
                    resourceURL = cl.getResource(resourcePath);
                    if (resourceURL == null) {
                        throw new IOException("Could not find " + resourcePath + " in the server classpath!");
                    }
                } else {
                    if (vfResource == null) {
                        throw new IOException("Could not find " + resourcePath + " in the additional metadatafiles!");
                    }
                    resourceURL = vfResource.toURL();
                }
            }
        }
        return resourceURL;
    }
}

