/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.deployment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.wsf.spi.WSFRuntime;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.deployment.DeploymentAspectManager;
import org.jboss.wsf.spi.deployment.WSFDeploymentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentAspectManagerImpl
implements DeploymentAspectManager {
    private static final Logger log = Logger.getLogger(DeploymentAspectManagerImpl.class);
    private String name;
    private DeploymentAspectManager parent;
    private List<DeploymentAspect> depAspects = new ArrayList<DeploymentAspect>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DeploymentAspectManager getParent() {
        return this.parent;
    }

    public void setParent(DeploymentAspectManager parent) {
        this.parent = parent;
    }

    public List<DeploymentAspect> getDeploymentAspects() {
        return Collections.unmodifiableList(this.depAspects);
    }

    public void setDeploymentAspects(List<DeploymentAspect> aspects) {
        this.depAspects.clear();
        this.depAspects.addAll(aspects);
        StringBuilder builder = new StringBuilder("setDeploymentAspects on " + this.name);
        for (DeploymentAspect aspect : aspects) {
            builder.append("\n  ").append(aspect.getClass().getName()).append(" provides: ").append(aspect.getProvidesAsSet()).append(" requires: ").append(aspect.getRequiresAsSet());
        }
        log.debug((Object)builder);
    }

    public void create(Deployment dep, WSFRuntime runtime) {
        HashSet providedConditions = new HashSet();
        for (int i = 0; i < this.getDeploymentAspects().size(); ++i) {
            DeploymentAspect aspect = this.getDeploymentAspects().get(i);
            this.logInvocation(aspect, "Create");
            aspect.create(dep, runtime);
            providedConditions.addAll(aspect.getProvidesAsSet());
        }
        dep.setState(Deployment.DeploymentState.CREATED);
    }

    public void start(Deployment dep, WSFRuntime runtime) {
        for (int i = 0; i < this.getDeploymentAspects().size(); ++i) {
            DeploymentAspect aspect = this.getDeploymentAspects().get(i);
            try {
                this.logInvocation(aspect, "Start");
                aspect.start(dep, runtime);
                continue;
            }
            catch (RuntimeException rte) {
                while (i-- >= 0) {
                    this.failsafeDestroy(aspect, dep, runtime);
                }
                throw rte;
            }
        }
        dep.setState(Deployment.DeploymentState.STARTED);
    }

    public void stop(Deployment dep, WSFRuntime runtime) {
        for (int i = this.getDeploymentAspects().size(); 0 < i; --i) {
            DeploymentAspect aspect = this.getDeploymentAspects().get(i - 1);
            this.failsafeStop(aspect, dep, runtime);
        }
        dep.setState(Deployment.DeploymentState.STOPPED);
    }

    public void destroy(Deployment dep, WSFRuntime runtime) {
        for (int i = this.getDeploymentAspects().size(); 0 < i; --i) {
            DeploymentAspect aspect = this.getDeploymentAspects().get(i - 1);
            this.failsafeDestroy(aspect, dep, runtime);
        }
        dep.setState(Deployment.DeploymentState.DESTROYED);
    }

    private void failsafeStop(DeploymentAspect aspect, Deployment dep, WSFRuntime runtime) {
        try {
            this.logInvocation(aspect, "Stop");
            aspect.stop(dep, runtime);
        }
        catch (RuntimeException rte) {
            WSFDeploymentException.rethrow((Throwable)rte);
        }
    }

    private void failsafeDestroy(DeploymentAspect aspect, Deployment dep, WSFRuntime runtime) {
        try {
            this.logInvocation(aspect, "Destroy");
            aspect.destroy(dep, runtime);
        }
        catch (RuntimeException rte) {
            WSFDeploymentException.rethrow((Throwable)rte);
        }
    }

    private void logInvocation(DeploymentAspect aspect, String method) {
        String name = aspect.getClass().getName();
        name = name.substring(name.lastIndexOf(".") + 1);
        log.debug((Object)(name + ":" + method));
    }

    public String toString() {
        return this.name + " :" + super.toString();
    }
}

