/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.cmd;

import java.net.URISyntaxException;
import java.net.URL;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.util.Loader;

final class Log4JUtil {
    public static final String LOG4J_CONFIGURATION = "log4j.configuration";
    public static final String LOG4J_PROPERTIES = "log4j.properties";

    private Log4JUtil() {
    }

    public static boolean isLog4jConfigurationAvailable() {
        String log4jConfiguration = System.getProperty(LOG4J_CONFIGURATION);
        String resource = log4jConfiguration != null ? log4jConfiguration : LOG4J_PROPERTIES;
        URL url = null;
        try {
            url = new URL(resource);
            Log4JUtil.loadConfiguration(url);
        }
        catch (Exception e1) {
            try {
                url = Loader.getResource((String)resource, null);
                Log4JUtil.loadConfiguration(url);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return url != null;
    }

    private static void loadConfiguration(URL log4jConfigurationFile) throws URISyntaxException {
        if (log4jConfigurationFile == null) {
            return;
        }
        LoggerContext.getContext().setConfigLocation(log4jConfigurationFile.toURI());
    }
}

