/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.api.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class BundleUtils {
    private static final String BUNDLE_FILE_NAME = ".Message";

    private BundleUtils() {
    }

    public static ResourceBundle getBundle(Class<?> cls) {
        String bundleName = cls.getPackage().getName() + BUNDLE_FILE_NAME;
        try {
            return ResourceBundle.getBundle(bundleName, Locale.getDefault(), cls.getClassLoader());
        }
        catch (MissingResourceException ex) {
            return ResourceBundle.getBundle(bundleName, Locale.getDefault(), Thread.currentThread().getContextClassLoader());
        }
    }

    public static String getMessage(ResourceBundle bundle2, String key, Object ... params) {
        String fmt = null;
        try {
            if (null == bundle2) {
                return key;
            }
            fmt = bundle2.getString(key);
        }
        catch (MissingResourceException ex) {
            return key;
        }
        return MessageFormat.format(fmt, params);
    }
}

