/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.configuration;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.xml.ws.Binding;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.annotations.UseAsyncMethod;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.ServiceImpl;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.jboss.ws.api.util.ServiceLoader;
import org.jboss.ws.common.configuration.BasicConfigResolver;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.deployment.AnnotationsInfo;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.metadata.config.CommonConfig;
import org.jboss.wsf.spi.metadata.config.EndpointConfig;
import org.jboss.wsf.spi.security.JASPIAuthenticationProvider;
import org.jboss.wsf.stack.cxf.JBossWSInvoker;
import org.jboss.wsf.stack.cxf.client.configuration.BeanCustomizer;
import org.jboss.wsf.stack.cxf.deployment.EndpointImpl;
import org.jboss.wsf.stack.cxf.deployment.WSDLFilePublisher;
import org.jboss.wsf.stack.cxf.i18n.Loggers;
import org.jboss.wsf.stack.cxf.interceptor.TCCLAwareInterceptorReplacer;
import org.jboss.wsf.stack.cxf.security.authentication.AuthenticationMgrSubjectCreatingInterceptor;
import org.jboss.wsf.stack.cxf.transport.JBossWSDestinationRegistryImpl;

public class ServerBeanCustomizer
extends BeanCustomizer {
    private WSDLFilePublisher wsdlPublisher;
    private ArchiveDeployment dep;

    public void customize(Object beanInstance) {
        DestinationRegistry oldRegistry;
        List depEndpoints;
        ServerFactoryBean factory;
        if (beanInstance instanceof EndpointImpl) {
            this.configureEndpoint((EndpointImpl)((Object)beanInstance));
        }
        if (beanInstance instanceof JaxWsEndpointImpl) {
            JaxWsEndpointImpl jaxwsEndpoint = (JaxWsEndpointImpl)beanInstance;
            Binding jaxwsBinding = jaxwsEndpoint.getJaxwsBinding();
            TCCLAwareInterceptorReplacer interceptorReplacer = new TCCLAwareInterceptorReplacer(jaxwsBinding);
            jaxwsEndpoint.getInInterceptors().replaceAll(interceptorReplacer);
            jaxwsEndpoint.getOutInterceptors().replaceAll(interceptorReplacer);
            jaxwsEndpoint.getInFaultInterceptors().replaceAll(interceptorReplacer);
            jaxwsEndpoint.getOutFaultInterceptors().replaceAll(interceptorReplacer);
            Service service = jaxwsEndpoint.getService();
            service.getInInterceptors().replaceAll(interceptorReplacer);
            service.getOutInterceptors().replaceAll(interceptorReplacer);
            service.getInFaultInterceptors().replaceAll(interceptorReplacer);
            service.getOutFaultInterceptors().replaceAll(interceptorReplacer);
            Bus bus = BusFactory.getThreadDefaultBus((boolean)false);
            bus.getInInterceptors().replaceAll(interceptorReplacer);
            bus.getOutInterceptors().replaceAll(interceptorReplacer);
            bus.getInFaultInterceptors().replaceAll(interceptorReplacer);
            bus.getOutFaultInterceptors().replaceAll(interceptorReplacer);
            org.apache.cxf.binding.Binding binding = jaxwsEndpoint.getBinding();
            binding.getInInterceptors().replaceAll(interceptorReplacer);
            binding.getOutInterceptors().replaceAll(interceptorReplacer);
            binding.getInFaultInterceptors().replaceAll(interceptorReplacer);
            binding.getOutFaultInterceptors().replaceAll(interceptorReplacer);
        }
        if (beanInstance instanceof ServerFactoryBean) {
            factory = (ServerFactoryBean)beanInstance;
            if (factory.getInvoker() instanceof JBossWSInvoker) {
                ((JBossWSInvoker)factory.getInvoker()).setTargetBean(factory.getServiceBean());
            }
            if ((depEndpoints = this.dep.getService().getEndpoints()) != null) {
                String targetBeanName = factory.getServiceBean().getClass().getName();
                for (org.jboss.wsf.spi.deployment.Endpoint depEndpoint : depEndpoints) {
                    if (!depEndpoint.getTargetBeanClass().getName().equals(targetBeanName)) continue;
                    depEndpoint.addAttachment(Object.class, factory.getServiceBean());
                }
            }
        }
        if (beanInstance instanceof ServiceImpl) {
            ServiceImpl service = (ServiceImpl)beanInstance;
            depEndpoints = this.dep.getService().getEndpoints();
            if (depEndpoints != null) {
                Collection eps = service.getEndpoints().values();
                for (org.jboss.wsf.spi.deployment.Endpoint depEp : depEndpoints) {
                    for (Endpoint ep : eps) {
                        if (!ep.getService().getName().equals(depEp.getProperty("javax.xml.ws.wsdl.service")) || !ep.getEndpointInfo().getName().equals(depEp.getProperty("javax.xml.ws.wsdl.port")) || !ep.getEndpointInfo().getAddress().equals(depEp.getAddress())) continue;
                        depEp.addAttachment(Endpoint.class, (Object)ep);
                    }
                }
            }
        }
        if (beanInstance instanceof HTTPTransportFactory && !((oldRegistry = (factory = (HTTPTransportFactory)beanInstance).getRegistry()) instanceof JBossWSDestinationRegistryImpl)) {
            factory.setRegistry((DestinationRegistry)new JBossWSDestinationRegistryImpl());
        }
        super.customize(beanInstance);
    }

    protected void configureEndpoint(EndpointImpl endpoint) {
        if (this.wsdlPublisher != null) {
            endpoint.setWsdlPublisher(this.wsdlPublisher);
        }
        if (!endpoint.isPublished()) {
            boolean isHttpEndpoint;
            Object implementor = endpoint.getImplementor();
            boolean bl = isHttpEndpoint = endpoint.getAddress() != null && endpoint.getAddress().substring(0, 5).toLowerCase(Locale.ENGLISH).startsWith("http");
            if (endpoint.getInvoker() == null && isHttpEndpoint) {
                AnnotationsInfo ai = (AnnotationsInfo)this.dep.getAttachment(AnnotationsInfo.class);
                endpoint.setInvoker(new JBossWSInvoker(ai.hasAnnotatedClasses(new String[]{UseAsyncMethod.class.getName()})));
            }
            String endpointClassName = implementor.getClass().getName();
            List depEndpoints = this.dep.getService().getEndpoints();
            for (org.jboss.wsf.spi.deployment.Endpoint depEndpoint : depEndpoints) {
                if (!endpointClassName.equals(depEndpoint.getTargetBeanName())) continue;
                EndpointConfig config = depEndpoint.getEndpointConfig();
                if (config == null) {
                    BasicConfigResolver bcr = new BasicConfigResolver(this.dep, implementor.getClass());
                    config = bcr.resolveEndpointConfig();
                    depEndpoint.setEndpointConfig(config);
                }
                if (config != null) {
                    endpoint.setEndpointConfig((CommonConfig)config);
                }
                depEndpoint.setProperty("javax.xml.ws.wsdl.port", (Object)endpoint.getEndpointName());
                depEndpoint.setProperty("javax.xml.ws.wsdl.service", (Object)endpoint.getServiceName());
            }
            JASPIAuthenticationProvider jaspiProvider = (JASPIAuthenticationProvider)ServiceLoader.loadService((String)JASPIAuthenticationProvider.class.getName(), null, (ClassLoader)ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader());
            if (jaspiProvider == null) {
                Loggers.DEPLOYMENT_LOGGER.cannotFindJaspiClasses();
            } else if (jaspiProvider.enableServerAuthentication((Object)endpoint, (org.jboss.wsf.spi.deployment.Endpoint)depEndpoints.get(0))) {
                endpoint.getInInterceptors().add(new AuthenticationMgrSubjectCreatingInterceptor());
            }
        }
    }

    public void setWsdlPublisher(WSDLFilePublisher wsdlPublisher) {
        this.wsdlPublisher = wsdlPublisher;
    }

    public void setDeployment(ArchiveDeployment dep) {
        this.dep = dep;
    }
}

