/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.jboss.ws.common.management.AbstractServerConfig;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.RequestHandler;
import org.jboss.wsf.spi.management.EndpointMetrics;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.metadata.config.SOAPAddressRewriteMetadata;
import org.jboss.wsf.stack.cxf.Messages;
import org.jboss.wsf.stack.cxf.addressRewrite.SoapAddressRewriteHelper;
import org.jboss.wsf.stack.cxf.configuration.BusHolder;

public class RequestHandlerImpl
implements RequestHandler {
    private static final RequestHandlerImpl me = new RequestHandlerImpl();
    private static final Pattern pathPattern = Pattern.compile("/{2,}");

    RequestHandlerImpl() {
    }

    static RequestHandlerImpl getInstance() {
        return me;
    }

    public void handleHttpRequest(Endpoint ep, HttpServletRequest req, HttpServletResponse res, ServletContext context) throws ServletException, IOException {
        boolean isGetWithQueryString;
        boolean isGet = "GET".equals(req.getMethod());
        boolean bl = isGetWithQueryString = isGet && this.hasQueryString(req);
        if (isGet && !isGetWithQueryString) {
            res.setStatus(405);
            res.setContentType("text/plain");
            PrintWriter out = res.getWriter();
            ((Writer)out).write("HTTP GET not supported");
            ((Writer)out).close();
            return;
        }
        boolean statisticsEnabled = RequestHandlerImpl.getServerConfig().isStatisticsEnabled();
        Long beginTime = statisticsEnabled ? this.initRequestMetrics(ep) : 0L;
        Deployment dep = ep.getService().getDeployment();
        AbstractHTTPDestination dest = this.findDestination(req, ((BusHolder)dep.getAttachment(BusHolder.class)).getBus());
        HttpServletResponseWrapper response = new HttpServletResponseWrapper(res);
        try {
            ServletConfig cfg = (ServletConfig)context.getAttribute(ServletConfig.class.getName());
            if (isGetWithQueryString) {
                EndpointInfo endpointInfo = dest.getEndpointInfo();
                boolean autoRewrite = SoapAddressRewriteHelper.isAutoRewriteOn((SOAPAddressRewriteMetadata)dep.getAttachment(SOAPAddressRewriteMetadata.class));
                endpointInfo.setProperty("autoRewriteSoapAddress", (Object)autoRewrite);
                endpointInfo.setProperty("autoRewriteSoapAddressForAllServices", (Object)autoRewrite);
            }
            dest.invoke(cfg, context, req, (HttpServletResponse)response);
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
        if (response.getStatus() < 500 && statisticsEnabled) {
            this.processResponseMetrics(ep, beginTime);
        }
        if (response.getStatus() >= 500 && statisticsEnabled) {
            this.processFaultMetrics(ep, beginTime);
        }
    }

    private boolean hasQueryString(HttpServletRequest req) {
        String queryString = req.getQueryString();
        return null != queryString && queryString.length() > 0;
    }

    private AbstractHTTPDestination findDestination(HttpServletRequest req, Bus bus) throws ServletException {
        String requestURI = req.getRequestURI();
        DestinationRegistry destRegistry = RequestHandlerImpl.getDestinationRegistryFromBus(bus);
        if (destRegistry == null) {
            throw Messages.MESSAGES.cannotObtainRegistry(DestinationRegistry.class.getName());
        }
        AbstractHTTPDestination dest = destRegistry.getDestinationForPath(requestURI = pathPattern.matcher(requestURI).replaceAll("/"), true);
        if (dest != null) {
            return dest;
        }
        Collection destinations = destRegistry.getDestinations();
        AbstractHTTPDestination returnValue = null;
        for (AbstractHTTPDestination destination : destinations) {
            String path = destination.getEndpointInfo().getAddress();
            try {
                path = new URL(path).getPath();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (path == null || !requestURI.startsWith(path)) continue;
            returnValue = destination;
        }
        if (returnValue == null) {
            throw Messages.MESSAGES.cannotObtainDestinationFor(requestURI);
        }
        return returnValue;
    }

    private static DestinationRegistry getDestinationRegistryFromBus(Bus bus) throws ServletException {
        DestinationFactoryManager dfm = (DestinationFactoryManager)bus.getExtension(DestinationFactoryManager.class);
        try {
            DestinationFactory df = dfm.getDestinationFactory("http://cxf.apache.org/transports/http/configuration");
            if (df instanceof HTTPTransportFactory) {
                HTTPTransportFactory transportFactory = (HTTPTransportFactory)df;
                return transportFactory.getRegistry();
            }
        }
        catch (BusException e) {
            throw Messages.MESSAGES.cannotObtainDestinationFactoryForHttpTransport((Throwable)e);
        }
        return null;
    }

    private static ServerConfig getServerConfig() {
        if (System.getSecurityManager() == null) {
            return AbstractServerConfig.getServerIntegrationServerConfig();
        }
        return (ServerConfig)AccessController.doPrivileged(AbstractServerConfig.GET_SERVER_INTEGRATION_SERVER_CONFIG);
    }

    private long initRequestMetrics(Endpoint endpoint) {
        long beginTime = 0L;
        EndpointMetrics metrics = endpoint.getEndpointMetrics();
        if (metrics != null) {
            beginTime = metrics.processRequestMessage();
        }
        return beginTime;
    }

    private void processResponseMetrics(Endpoint endpoint, long beginTime) {
        EndpointMetrics metrics = endpoint.getEndpointMetrics();
        if (metrics != null) {
            metrics.processResponseMessage(beginTime);
        }
    }

    private void processFaultMetrics(Endpoint endpoint, long beginTime) {
        EndpointMetrics metrics = endpoint.getEndpointMetrics();
        if (metrics != null) {
            metrics.processFaultMessage(beginTime);
        }
    }
}

