/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.interceptor;

import java.lang.reflect.Method;
import java.security.Principal;
import java.util.List;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.LogicalMessageContext;
import javax.xml.ws.handler.MessageContext;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.jaxws.handler.HandlerChainInvoker;
import org.apache.cxf.jaxws.handler.logical.LogicalHandlerInInterceptor;
import org.apache.cxf.jaxws.handler.soap.SOAPHandlerInterceptor;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.invoker.MethodDispatcher;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.jboss.wsf.spi.security.EJBMethodSecurityAttribute;
import org.jboss.wsf.spi.security.EJBMethodSecurityAttributeProvider;
import org.jboss.wsf.stack.cxf.Messages;

public class HandlerAuthInterceptor
extends AbstractPhaseInterceptor<Message> {
    public HandlerAuthInterceptor() {
        super("pre-protocol-frontend");
        this.addBefore(SOAPHandlerInterceptor.class.getName());
        this.addBefore(LogicalHandlerInInterceptor.class.getName());
    }

    public void handleMessage(Message message) throws Fault {
        JaxWsEndpointImpl ep;
        List handlerChain;
        Endpoint endpoint;
        Exchange ex = message.getExchange();
        HandlerChainInvoker invoker = (HandlerChainInvoker)ex.get(HandlerChainInvoker.class);
        if (null == invoker && (endpoint = ex.getEndpoint()) instanceof JaxWsEndpointImpl && (handlerChain = (ep = (JaxWsEndpointImpl)endpoint).getJaxwsBinding().getHandlerChain()) != null && !handlerChain.isEmpty()) {
            invoker = new JBossWSHandlerChainInvoker(handlerChain, this.isOutbound(message, ex));
            ex.put(HandlerChainInvoker.class, (Object)invoker);
        }
    }

    private boolean isOutbound(Message message, Exchange ex) {
        return message == ex.getOutMessage() || message == ex.getOutFaultMessage();
    }

    private class JBossWSHandlerChainInvoker
    extends HandlerChainInvoker {
        public JBossWSHandlerChainInvoker(List<Handler> hc, boolean isOutbound) {
            super(hc, isOutbound);
        }

        public boolean invokeLogicalHandlers(boolean requestor, LogicalMessageContext context) {
            this.checkAuthorization((MessageContext)context);
            return super.invokeLogicalHandlers(requestor, context);
        }

        public boolean invokeProtocolHandlers(boolean requestor, MessageContext context) {
            this.checkAuthorization(context);
            return super.invokeProtocolHandlers(requestor, context);
        }

        protected void checkAuthorization(MessageContext ctx) {
            if (((Boolean)ctx.get((Object)"javax.xml.ws.handler.message.outbound")).booleanValue()) {
                return;
            }
            Message message = ((WrappedMessageContext)ctx).getWrappedMessage();
            Exchange exchange = message.getExchange();
            org.jboss.wsf.spi.deployment.Endpoint ep = (org.jboss.wsf.spi.deployment.Endpoint)exchange.get(org.jboss.wsf.spi.deployment.Endpoint.class);
            EJBMethodSecurityAttributeProvider attributeProvider = (EJBMethodSecurityAttributeProvider)ep.getAttachment(EJBMethodSecurityAttributeProvider.class);
            if (attributeProvider != null) {
                Principal p;
                SecurityContext secCtx = (SecurityContext)message.get(SecurityContext.class);
                BindingOperationInfo bop = (BindingOperationInfo)exchange.get(BindingOperationInfo.class);
                MethodDispatcher md = (MethodDispatcher)((Service)exchange.get(Service.class)).get((Object)MethodDispatcher.class.getName());
                Method method = md.getMethod(bop);
                EJBMethodSecurityAttribute attributes = attributeProvider.getSecurityAttributes(method);
                if (attributes == null || attributes.isPermitAll()) {
                    return;
                }
                if (!attributes.isDenyAll() && attributes.getRolesAllowed() != null) {
                    for (String role : attributes.getRolesAllowed()) {
                        if (!secCtx.isUserInRole(role)) continue;
                        return;
                    }
                }
                throw Messages.MESSAGES.authorizationFailed((p = secCtx.getUserPrincipal()) != null ? p.getName() : null);
            }
        }
    }
}

