/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.configuration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapTransportFactory;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.ResourceResolver;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.workqueue.AutomaticWorkQueue;
import org.apache.cxf.workqueue.AutomaticWorkQueueImpl;
import org.apache.cxf.workqueue.WorkQueueManager;
import org.apache.cxf.ws.policy.AlternativeSelector;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.cxf.ws.policy.selector.MaximalAlternativeSelector;
import org.jboss.ws.api.binding.BindingCustomization;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.webservices.JBossWebservicesMetaData;
import org.jboss.wsf.stack.cxf.deployment.WSDLFilePublisher;
import org.jboss.wsf.stack.cxf.interceptor.EnableDecoupledFaultInterceptor;
import org.jboss.wsf.stack.cxf.interceptor.EndpointAssociationInterceptor;
import org.jboss.wsf.stack.cxf.interceptor.NsCtxSelectorStoreInterceptor;

public abstract class BusHolder {
    public static final String PARAM_CXF_BEANS_URL = "jbossws.cxf.beans.url";
    protected Bus bus;
    protected BusHolderLifeCycleListener busHolderListener;

    public BusHolder() {
    }

    public BusHolder(Bus bus) {
        this.setBus(bus);
    }

    public void configure(SoapTransportFactory soapTransportFactory, ResourceResolver resolver, Configurer configurer, JBossWebservicesMetaData wsmd) {
        Map props;
        this.bus.setProperty("deployment-bus", (Object)true);
        this.busHolderListener = new BusHolderLifeCycleListener();
        ((BusLifeCycleManager)this.bus.getExtension(BusLifeCycleManager.class)).registerLifeCycleListener((BusLifeCycleListener)this.busHolderListener);
        if (configurer != null) {
            this.bus.setExtension((Object)configurer, Configurer.class);
        }
        BusHolder.setInterceptors(this.bus);
        BusHolder.setSoapTransportFactory(this.bus, soapTransportFactory);
        BusHolder.setResourceResolver(this.bus, resolver);
        Map map = props = wsmd == null ? null : wsmd.getProperties();
        if (this.bus.getExtension(PolicyEngine.class) != null) {
            ((PolicyEngine)this.bus.getExtension(PolicyEngine.class)).setAlternativeSelector(BusHolder.getAlternativeSelector(props));
        }
        BusHolder.setAdditionalWorkQueues(this.bus, props);
    }

    public void close() {
        if (this.busHolderListener == null || !this.busHolderListener.isPreShutdown()) {
            this.bus.shutdown(true);
        }
        this.busHolderListener = null;
    }

    public abstract Configurer createServerConfigurer(BindingCustomization var1, WSDLFilePublisher var2, List<Endpoint> var3, UnifiedVirtualFile var4, String var5, String var6);

    protected static void setInterceptors(Bus bus) {
        bus.getInInterceptors().add(new EndpointAssociationInterceptor());
        bus.getInInterceptors().add(new EnableDecoupledFaultInterceptor());
        bus.getInInterceptors().add(new NsCtxSelectorStoreInterceptor());
    }

    protected static void setResourceResolver(Bus bus, ResourceResolver resourceResolver) {
        if (resourceResolver != null) {
            ((ResourceManager)bus.getExtension(ResourceManager.class)).addResourceResolver(resourceResolver);
        }
    }

    protected static void setSoapTransportFactory(Bus bus, SoapTransportFactory factory) {
        if (factory != null) {
            DestinationFactoryManager dfm = (DestinationFactoryManager)bus.getExtension(DestinationFactoryManager.class);
            factory.setBus(bus);
            dfm.registerDestinationFactory("http://schemas.xmlsoap.org/wsdl/soap/", (DestinationFactory)factory);
            dfm.registerDestinationFactory("http://schemas.xmlsoap.org/wsdl/soap12/", (DestinationFactory)factory);
        }
    }

    protected static void setAdditionalWorkQueues(Bus bus, Map<String, String> props) {
        if (props != null && !props.isEmpty()) {
            HashMap<String, HashMap<String, String>> queuesMap = new HashMap<String, HashMap<String, String>>();
            for (String k : props.keySet()) {
                String sk;
                int i;
                if (!k.startsWith("cxf.queue.") || (i = (sk = k.substring("cxf.queue.".length())).indexOf(".")) <= 0) continue;
                String queueName = sk.substring(0, i);
                String queueProp = sk.substring(i + 1);
                HashMap<String, String> m = (HashMap<String, String>)queuesMap.get(queueName);
                if (m == null) {
                    m = new HashMap<String, String>();
                    queuesMap.put(queueName, m);
                }
                m.put(queueProp, props.get(k));
            }
            WorkQueueManager mgr = (WorkQueueManager)bus.getExtension(WorkQueueManager.class);
            for (String queueName : queuesMap.keySet()) {
                AutomaticWorkQueue q = BusHolder.createWorkQueue(queueName, (Map)queuesMap.get(queueName));
                mgr.addNamedWorkQueue(queueName, q);
            }
        }
    }

    private static AlternativeSelector getAlternativeSelector(Map<String, String> props) {
        String className;
        MaximalAlternativeSelector selector = new MaximalAlternativeSelector();
        if (props != null && !props.isEmpty() && (className = props.get("cxf.policy.alternativeSelector")) != null) {
            try {
                Class<?> clazz = Class.forName(className);
                selector = (AlternativeSelector)clazz.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return selector;
    }

    private static AutomaticWorkQueue createWorkQueue(String name, Map<String, String> props) {
        int mqs = BusHolder.parseInt(props.get("maxQueueSize"), 256);
        int initialThreads = BusHolder.parseInt(props.get("initialThreads"), 0);
        int highWaterMark = BusHolder.parseInt(props.get("highWaterMark"), 25);
        int lowWaterMark = BusHolder.parseInt(props.get("lowWaterMark"), 5);
        long dequeueTimeout = BusHolder.parseLong(props.get("dequeueTimeout"), 120000L);
        return new AutomaticWorkQueueImpl(mqs, initialThreads, highWaterMark, lowWaterMark, dequeueTimeout, name);
    }

    private static int parseInt(String prop, int defaultValue) {
        return prop != null ? Integer.parseInt(prop) : defaultValue;
    }

    private static long parseLong(String prop, long defaultValue) {
        return prop != null ? Long.parseLong(prop) : defaultValue;
    }

    public Bus getBus() {
        return this.bus;
    }

    protected void setBus(Bus bus) {
        this.bus = bus;
    }

    private class BusHolderLifeCycleListener
    implements BusLifeCycleListener {
        private volatile boolean preShutdown = false;

        private BusHolderLifeCycleListener() {
        }

        public boolean isPreShutdown() {
            return this.preShutdown;
        }

        public void initComplete() {
        }

        public void preShutdown() {
            this.preShutdown = true;
        }

        public void postShutdown() {
        }
    }
}

