/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2011, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.wsf.stack.cxf.deployment.aspect;

import java.util.ResourceBundle;

import org.apache.cxf.frontend.ServerFactoryBean;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.integration.AbstractDeploymentAspect;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.stack.cxf.CXFInstanceProvider;
import org.jboss.wsf.stack.cxf.client.util.SpringUtils;


/**
 * Instance provider DA.
 *
 * @author <a href="mailto:ropalka@redhat.com">Richard Opalka</a>
 */
public final class CXFInstanceProviderDeploymentAspect extends AbstractDeploymentAspect
{
    private static final ResourceBundle bundle = BundleUtils.getBundle(CXFInstanceProviderDeploymentAspect.class);
    @Override
    public void start(final Deployment dep)
    {
       for (final Endpoint ep : dep.getService().getEndpoints())
       {
          final ServerFactoryBean factory = ep.getAttachment(ServerFactoryBean.class);
         //TODO: remove this after JBWS-3396 resolved
         if (factory == null && SpringUtils.isSpringAvailable())
         {
            throw new IllegalStateException(BundleUtils.getMessage(bundle, "SPRING_ENDPOINT_NOT_DEFINED", ep.getTargetBeanName()));
         }         
         ep.setInstanceProvider(new CXFInstanceProvider(factory));
       }
    }

}
