/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.configuration;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.jboss.ws.api.annotation.EndpointConfig;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.management.ServerConfigFactory;
import org.jboss.wsf.spi.metadata.config.CommonConfig;
import org.jboss.wsf.spi.metadata.config.ConfigMetaDataParser;
import org.jboss.wsf.spi.metadata.config.ConfigRoot;
import org.jboss.wsf.stack.cxf.JBossWSInvoker;
import org.jboss.wsf.stack.cxf.client.configuration.BeanCustomizer;
import org.jboss.wsf.stack.cxf.deployment.EndpointImpl;
import org.jboss.wsf.stack.cxf.deployment.WSDLFilePublisher;

public class ServerBeanCustomizer
extends BeanCustomizer {
    private static final ResourceBundle bundle = BundleUtils.getBundle(ServerBeanCustomizer.class);
    private static ServerConfig serverConfig;
    private WSDLFilePublisher wsdlPublisher;
    private List<Endpoint> depEndpoints;
    private UnifiedVirtualFile deploymentRoot;

    public void customize(Object beanInstance) {
        if (beanInstance instanceof EndpointImpl) {
            this.configureEndpoint((EndpointImpl)((Object)beanInstance));
        }
        if (beanInstance instanceof ServerFactoryBean) {
            ServerFactoryBean factory = (ServerFactoryBean)beanInstance;
            if (factory.getInvoker() instanceof JBossWSInvoker) {
                ((JBossWSInvoker)factory.getInvoker()).setTargetBean(factory.getServiceBean());
            }
            if (this.depEndpoints != null) {
                for (Endpoint depEndpoint : this.depEndpoints) {
                    if (!depEndpoint.getTargetBeanClass().isAssignableFrom(factory.getServiceBean().getClass())) continue;
                    depEndpoint.addAttachment(ServerFactoryBean.class, (Object)factory);
                }
            }
        }
        super.customize(beanInstance);
    }

    protected void configureEndpoint(EndpointImpl endpoint) {
        if (this.wsdlPublisher != null) {
            endpoint.setWsdlPublisher(this.wsdlPublisher);
        }
        if (!endpoint.isPublished()) {
            boolean isHttpEndpoint;
            Object implementor = endpoint.getImplementor();
            boolean bl = isHttpEndpoint = endpoint.getAddress() != null && endpoint.getAddress().substring(0, 5).toLowerCase().startsWith("http");
            if (endpoint.getInvoker() == null && isHttpEndpoint) {
                endpoint.setInvoker(new JBossWSInvoker());
            }
            EndpointConfig epConfig = implementor.getClass().getAnnotation(EndpointConfig.class);
            String configName = "Standard-Endpoint-Config";
            String configFile = null;
            if (epConfig != null) {
                if (!epConfig.configName().isEmpty()) {
                    configName = epConfig.configName();
                }
                if (!epConfig.configFile().isEmpty()) {
                    configFile = epConfig.configFile();
                }
            }
            if (configFile == null) {
                ServerConfig sc = ServerBeanCustomizer.getServerConfig();
                for (org.jboss.wsf.spi.metadata.config.EndpointConfig config : sc.getEndpointConfigs()) {
                    if (!config.getConfigName().equals(configName)) continue;
                    endpoint.setEndpointConfig((CommonConfig)config);
                    break;
                }
            } else {
                try {
                    UnifiedVirtualFile vf = this.deploymentRoot.findChild(configFile);
                    ConfigRoot config = ConfigMetaDataParser.parse((URL)vf.toURL());
                    endpoint.setEndpointConfig((CommonConfig)config.getEndpointConfigByName(configName));
                }
                catch (IOException e) {
                    throw new RuntimeException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"COULD_NOT_READ", (Object[])new Object[]{configFile}));
                }
            }
        }
    }

    private static synchronized ServerConfig getServerConfig() {
        if (serverConfig == null) {
            ClassLoader cl = ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader();
            SPIProvider spiProvider = SPIProviderResolver.getInstance((ClassLoader)cl).getProvider();
            serverConfig = ((ServerConfigFactory)spiProvider.getSPI(ServerConfigFactory.class, cl)).getServerConfig();
        }
        return serverConfig;
    }

    public void setDeploymentRoot(UnifiedVirtualFile deploymentRoot) {
        this.deploymentRoot = deploymentRoot;
    }

    public void setWsdlPublisher(WSDLFilePublisher wsdlPublisher) {
        this.wsdlPublisher = wsdlPublisher;
    }

    public void setDeploymentEndpoints(List<Endpoint> endpoints) {
        this.depEndpoints = endpoints;
    }
}

