/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.configuration;

import java.util.List;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapTransportFactory;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.ResourceResolver;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.ws.policy.AlternativeSelector;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.cxf.ws.policy.selector.MaximalAlternativeSelector;
import org.jboss.ws.api.binding.BindingCustomization;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.stack.cxf.deployment.WSDLFilePublisher;
import org.jboss.wsf.stack.cxf.interceptor.EnableOneWayDecoupledFaultInterceptor;
import org.jboss.wsf.stack.cxf.interceptor.EndpointAssociationInterceptor;

public abstract class BusHolder {
    public static final String PARAM_CXF_BEANS_URL = "jbossws.cxf.beans.url";
    protected Bus bus;
    protected BusHolderLifeCycleListener busHolderListener;

    public BusHolder() {
    }

    public BusHolder(Bus bus) {
        this.setBus(bus);
    }

    public void configure(SoapTransportFactory soapTransportFactory, ResourceResolver resolver, Configurer configurer) {
        this.bus.setProperty("deployment-bus", (Object)true);
        this.busHolderListener = new BusHolderLifeCycleListener();
        ((BusLifeCycleManager)this.bus.getExtension(BusLifeCycleManager.class)).registerLifeCycleListener((BusLifeCycleListener)this.busHolderListener);
        if (configurer != null) {
            this.bus.setExtension((Object)configurer, Configurer.class);
        }
        BusHolder.setInterceptors(this.bus);
        BusHolder.setSoapTransportFactory(this.bus, soapTransportFactory);
        BusHolder.setResourceResolver(this.bus, resolver);
        if (this.bus.getExtension(PolicyEngine.class) != null) {
            ((PolicyEngine)this.bus.getExtension(PolicyEngine.class)).setAlternativeSelector((AlternativeSelector)new MaximalAlternativeSelector());
        }
    }

    public void close() {
        if (this.busHolderListener == null || !this.busHolderListener.isPreShutdown()) {
            this.bus.shutdown(true);
        }
        this.busHolderListener = null;
    }

    public abstract Configurer createServerConfigurer(BindingCustomization var1, WSDLFilePublisher var2, List<Endpoint> var3, UnifiedVirtualFile var4);

    protected static void setInterceptors(Bus bus) {
        bus.getInInterceptors().add(new EndpointAssociationInterceptor());
        bus.getInInterceptors().add(new EnableOneWayDecoupledFaultInterceptor());
    }

    protected static void setResourceResolver(Bus bus, ResourceResolver resourceResolver) {
        if (resourceResolver != null) {
            ((ResourceManager)bus.getExtension(ResourceManager.class)).addResourceResolver(resourceResolver);
        }
    }

    protected static void setSoapTransportFactory(Bus bus, SoapTransportFactory factory) {
        if (factory != null) {
            DestinationFactoryManager dfm = (DestinationFactoryManager)bus.getExtension(DestinationFactoryManager.class);
            factory.setBus(bus);
            dfm.registerDestinationFactory("http://schemas.xmlsoap.org/wsdl/soap/", (DestinationFactory)factory);
            dfm.registerDestinationFactory("http://schemas.xmlsoap.org/wsdl/soap12/", (DestinationFactory)factory);
        }
    }

    public Bus getBus() {
        return this.bus;
    }

    protected void setBus(Bus bus) {
        this.bus = bus;
    }

    private class BusHolderLifeCycleListener
    implements BusLifeCycleListener {
        private volatile boolean preShutdown = false;

        private BusHolderLifeCycleListener() {
        }

        public boolean isPreShutdown() {
            return this.preShutdown;
        }

        public void initComplete() {
        }

        public void preShutdown() {
            this.preShutdown = true;
        }

        public void postShutdown() {
        }
    }
}

