/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.configuration;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapTransportFactory;
import org.apache.cxf.bus.spring.BusApplicationContext;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.resource.ResourceResolver;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.servlet.ServletTransportFactory;
import org.apache.ws.security.WSSConfig;
import org.jboss.logging.Logger;
import org.jboss.wsf.spi.binding.BindingCustomization;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.stack.cxf.client.configuration.JBossWSSpringBusFactory;
import org.jboss.wsf.stack.cxf.configuration.BusHolder;
import org.jboss.wsf.stack.cxf.configuration.JBossWSServerSpringConfigurer;
import org.jboss.wsf.stack.cxf.configuration.SecurityActions;
import org.jboss.wsf.stack.cxf.configuration.ServerBeanCustomizer;
import org.jboss.wsf.stack.cxf.deployment.WSDLFilePublisher;
import org.jboss.wsf.stack.cxf.spring.handler.NamespaceHandlerResolver;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public class SpringBusHolder
extends BusHolder {
    private static final Logger log = Logger.getLogger(BusHolder.class);
    private boolean configured = false;
    protected BusApplicationContext ctx;
    protected List<GenericApplicationContext> additionalCtx = new LinkedList<GenericApplicationContext>();
    protected URL[] additionalLocations;

    public SpringBusHolder(URL location, URL ... additionalLocations) {
        this.additionalLocations = additionalLocations;
        this.createBus(location);
    }

    protected void createBus(URL location) {
        block4: {
            this.bus = new JBossWSSpringBusFactory().createBus();
            this.ctx = (BusApplicationContext)this.bus.getExtension(BusApplicationContext.class);
            if (location != null) {
                try {
                    this.additionalCtx.add(SpringBusHolder.loadAdditionalConfig((ApplicationContext)this.ctx, location));
                }
                catch (IOException e) {
                    if (!log.isTraceEnabled()) break block4;
                    log.trace((Object)("Could not load additional config from location: " + location), (Throwable)e);
                }
            }
        }
        ServletTransportFactory factory = new ServletTransportFactory(this.bus);
        for (String s : factory.getTransportIds()) {
            this.registerTransport((DestinationFactory)factory, s);
        }
    }

    @Override
    public void configure(SoapTransportFactory soapTransportFactory, ResourceResolver resolver, Configurer configurer) {
        block7: {
            if (this.configured) {
                throw new IllegalStateException("Underlying bus is already configured for JBossWS use!");
            }
            super.configure(soapTransportFactory, resolver, configurer);
            if (this.additionalLocations != null) {
                for (URL jbossCxfXml : this.additionalLocations) {
                    try {
                        this.additionalCtx.add(SpringBusHolder.loadAdditionalConfig((ApplicationContext)this.ctx, jbossCxfXml));
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Unable to load configuration from " + jbossCxfXml, e);
                    }
                }
            }
            try {
                WSSConfig.getNewInstance();
            }
            catch (Exception e) {
                log.warn((Object)"Could not early initialize security engine!");
                if (!log.isTraceEnabled()) break block7;
                log.trace((Object)"Error while getting default WSSConfig: ", (Throwable)e);
            }
        }
        this.configured = true;
    }

    @Override
    public Configurer createServerConfigurer(BindingCustomization customization, WSDLFilePublisher wsdlPublisher, List<Endpoint> depEndpoints) {
        ApplicationContext ctx = (ApplicationContext)this.bus.getExtension(BusApplicationContext.class);
        ServerBeanCustomizer customizer = new ServerBeanCustomizer();
        customizer.setBindingCustomization(customization);
        customizer.setWsdlPublisher(wsdlPublisher);
        customizer.setDeploymentEndpoints(depEndpoints);
        JBossWSServerSpringConfigurer serverConfigurer = new JBossWSServerSpringConfigurer(ctx);
        serverConfigurer.setCustomizer(customizer);
        return serverConfigurer;
    }

    protected static GenericApplicationContext loadAdditionalConfig(ApplicationContext ctx, URL locationUrl) throws IOException {
        if (locationUrl == null) {
            throw new IllegalArgumentException("Cannot load additional config from null location!");
        }
        InputStream is = locationUrl.openStream();
        GenericApplicationContext childCtx = new GenericApplicationContext(ctx);
        XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)childCtx);
        reader.setValidationMode(3);
        reader.setNamespaceHandlerResolver((org.springframework.beans.factory.xml.NamespaceHandlerResolver)new NamespaceHandlerResolver(SecurityActions.getContextClassLoader()));
        reader.loadBeanDefinitions((Resource)new InputStreamResource(is));
        childCtx.refresh();
        return childCtx;
    }

    @Override
    public void close() {
        for (GenericApplicationContext gac : this.additionalCtx) {
            gac.destroy();
        }
        super.close();
    }

    @Override
    protected void setBus(Bus bus) {
        super.setBus(bus);
        this.ctx = (BusApplicationContext)bus.getExtension(BusApplicationContext.class);
    }
}

