/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf;

import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.servlet.ServletController;
import org.apache.cxf.transport.servlet.ServletDestination;
import org.apache.cxf.transport.servlet.ServletTransportFactory;
import org.apache.cxf.transports.http.QueryHandler;
import org.apache.cxf.transports.http.QueryHandlerRegistry;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.management.EndpointMetrics;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.management.ServerConfigFactory;
import org.jboss.wsf.stack.cxf.HttpServletResponseExt;

public class ServletControllerExt
extends ServletController {
    private ServletTransportFactory cxfTransport;
    private Bus bus;
    private ServerConfig serverConfig;

    public ServletControllerExt(ServletTransportFactory cxfTransport, ServletConfig config, ServletContext servletCtx, Bus bus) {
        super(cxfTransport, config, servletCtx, bus);
        this.cxfTransport = cxfTransport;
        this.bus = bus;
        ClassLoader cl = ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader();
        SPIProvider spiProvider = SPIProviderResolver.getInstance((ClassLoader)cl).getProvider();
        this.serverConfig = ((ServerConfigFactory)spiProvider.getSPI(ServerConfigFactory.class, cl)).getServerConfig();
    }

    private ServletDestination findDestination(HttpServletRequest req) throws ServletException {
        String requestURI = req.getRequestURI();
        Collection destinations = this.cxfTransport.getDestinations();
        ServletDestination returnValue = null;
        for (ServletDestination destination : destinations) {
            String address;
            EndpointInfo endpointInfo = destination.getEndpointInfo();
            String path = address = endpointInfo.getAddress();
            try {
                path = new URL(address).getPath();
            }
            catch (MalformedURLException ex) {
                // empty catch block
            }
            if (path == null) continue;
            if (requestURI.equals(path)) {
                return destination;
            }
            if (!requestURI.startsWith(path)) continue;
            returnValue = destination;
        }
        if (returnValue == null) {
            throw new ServletException("Cannot obtain destination for: " + requestURI);
        }
        return returnValue;
    }

    private boolean handleQuery(HttpServletRequest req, HttpServletResponse res, ServletDestination dest) throws ServletException {
        boolean queryHandlerRegistryExists;
        boolean hasQuery = null != req.getQueryString() && req.getQueryString().length() > 0;
        boolean bl = queryHandlerRegistryExists = this.bus.getExtension(QueryHandlerRegistry.class) != null;
        if (hasQuery && queryHandlerRegistryExists) {
            String ctxUri = req.getRequestURI();
            String baseUri = req.getRequestURL().toString() + "?" + req.getQueryString();
            EndpointInfo endpointInfo = dest.getEndpointInfo();
            if ("jbossws.undefined.host".equals(this.serverConfig.getWebServiceHost())) {
                endpointInfo.setProperty("autoRewriteSoapAddress", (Object)true);
            }
            for (QueryHandler queryHandler : ((QueryHandlerRegistry)this.bus.getExtension(QueryHandlerRegistry.class)).getHandlers()) {
                if (!queryHandler.isRecognizedQuery(baseUri, ctxUri, endpointInfo)) continue;
                res.setContentType(queryHandler.getResponseContentType(baseUri, ctxUri));
                try {
                    ServletOutputStream out = res.getOutputStream();
                    queryHandler.writeResponse(baseUri, ctxUri, endpointInfo, (OutputStream)out);
                    out.flush();
                    return true;
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
            }
        }
        return false;
    }

    public void invoke(HttpServletRequest req, HttpServletResponse res, Endpoint ep) throws ServletException {
        ServletDestination dest = this.findDestination(req);
        boolean requestHandled = this.handleQuery(req, res, dest);
        if (!requestHandled) {
            Long beginTime = this.initRequestMetrics(ep);
            HttpServletResponseExt response = new HttpServletResponseExt(res);
            this.invokeDestination(req, response, dest);
            if (response.getStatus() < 500) {
                this.processResponseMetrics(ep, beginTime);
            } else {
                this.processFaultMetrics(ep, beginTime);
            }
        }
    }

    private long initRequestMetrics(Endpoint endpoint) {
        long beginTime = 0L;
        EndpointMetrics metrics = endpoint.getEndpointMetrics();
        if (metrics != null) {
            beginTime = metrics.processRequestMessage();
        }
        return beginTime;
    }

    private void processResponseMetrics(Endpoint endpoint, long beginTime) {
        EndpointMetrics metrics = endpoint.getEndpointMetrics();
        if (metrics != null) {
            metrics.processResponseMessage(beginTime);
        }
    }

    private void processFaultMetrics(Endpoint endpoint, long beginTime) {
        EndpointMetrics metrics = endpoint.getEndpointMetrics();
        if (metrics != null) {
            metrics.processFaultMessage(beginTime);
        }
    }
}

