/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.ResourceResolver;
import org.apache.cxf.transport.servlet.CXFNonSpringServlet;
import org.apache.cxf.transport.servlet.ServletContextResourceResolver;
import org.apache.cxf.transport.servlet.ServletController;
import org.apache.cxf.transport.servlet.ServletTransportFactory;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.ServletDelegate;
import org.jboss.wsf.stack.cxf.ServletControllerExt;
import org.jboss.wsf.stack.cxf.configuration.BusHolder;
import org.jboss.wsf.stack.cxf.transport.ServletHelper;

public class CXFNonSpringServletExt
extends CXFNonSpringServlet
implements ServletDelegate {
    protected Endpoint endpoint;

    public ServletController createServletController(ServletConfig servletConfig) {
        ServletTransportFactory stf = (ServletTransportFactory)this.createServletTransportFactory();
        return new ServletControllerExt(stf, servletConfig, servletConfig.getServletContext(), this.bus);
    }

    public void loadBus(ServletConfig servletConfig) throws ServletException {
        this.endpoint = ServletHelper.initEndpoint(servletConfig, this.getServletName());
        this.updateAvailableBusWithServletInfo(servletConfig);
        ServletHelper.registerInstrumentManger(this.bus, this.getServletContext());
    }

    private void updateAvailableBusWithServletInfo(ServletConfig servletConfig) {
        BusHolder holder = (BusHolder)this.endpoint.getService().getDeployment().getAttachment(BusHolder.class);
        this.bus = holder.getBus();
        BusFactory.setThreadDefaultBus((Bus)this.bus);
        ResourceManager resourceManager = (ResourceManager)this.bus.getExtension(ResourceManager.class);
        resourceManager.addResourceResolver((ResourceResolver)new ServletContextResourceResolver(servletConfig.getServletContext()));
        this.replaceDestinationFactory();
        this.controller = this.createServletController(servletConfig);
        servletConfig.getServletContext().setAttribute(ServletController.class.getName(), (Object)this.getController());
    }

    protected void invoke(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        ServletHelper.callRequestHandler(req, res, this.getServletContext(), this.getBus(), this.endpoint);
    }

    public void destroy() {
        ServletHelper.callPreDestroy(this.endpoint);
    }

    public void doHead(HttpServletRequest request, HttpServletResponse response, ServletContext context) throws ServletException, IOException {
        this.doHead(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response, ServletContext context) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response, ServletContext context) throws ServletException, IOException {
        this.doPost(request, response);
    }

    public void doPut(HttpServletRequest request, HttpServletResponse response, ServletContext context) throws ServletException, IOException {
        this.doPut(request, response);
    }

    public void doDelete(HttpServletRequest request, HttpServletResponse response, ServletContext context) throws ServletException, IOException {
        this.doDelete(request, response);
    }

    public void service(HttpServletRequest request, HttpServletResponse response, ServletContext context) throws ServletException, IOException {
        this.service(request, response);
    }
}

