/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.configuration;

import java.util.List;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapTransportFactory;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.ResourceResolver;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.jboss.wsf.spi.binding.BindingCustomization;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.stack.cxf.deployment.WSDLFilePublisher;
import org.jboss.wsf.stack.cxf.interceptor.EndpointAssociationInterceptor;

public abstract class BusHolder {
    public static final String PARAM_CXF_BEANS_URL = "jbossws.cxf.beans.url";
    protected Bus bus;

    public BusHolder() {
    }

    public BusHolder(Bus bus) {
        this.setBus(bus);
    }

    public void configure(SoapTransportFactory soapTransportFactory, ResourceResolver resolver, Configurer configurer) {
        if (configurer != null) {
            this.bus.setExtension((Object)configurer, Configurer.class);
        }
        BusHolder.setInterceptors(this.bus);
        BusHolder.setSoapTransportFactory(this.bus, soapTransportFactory);
        BusHolder.setResourceResolver(this.bus, resolver);
    }

    public void close() {
    }

    public abstract Configurer createServerConfigurer(BindingCustomization var1, WSDLFilePublisher var2, List<Endpoint> var3);

    protected static void setInterceptors(Bus bus) {
        bus.getInInterceptors().add(new EndpointAssociationInterceptor());
    }

    protected static void setResourceResolver(Bus bus, ResourceResolver resourceResolver) {
        if (resourceResolver != null) {
            ((ResourceManager)bus.getExtension(ResourceManager.class)).addResourceResolver(resourceResolver);
        }
    }

    protected static void setSoapTransportFactory(Bus bus, SoapTransportFactory factory) {
        if (factory != null) {
            DestinationFactoryManager dfm = (DestinationFactoryManager)bus.getExtension(DestinationFactoryManager.class);
            factory.setBus(bus);
            dfm.registerDestinationFactory("http://schemas.xmlsoap.org/wsdl/soap/", (DestinationFactory)factory);
            dfm.registerDestinationFactory("http://schemas.xmlsoap.org/wsdl/soap12/", (DestinationFactory)factory);
        }
    }

    protected void registerTransport(DestinationFactory factory, String namespace) {
        ((DestinationFactoryManager)this.bus.getExtension(DestinationFactoryManager.class)).registerDestinationFactory(namespace, factory);
    }

    public Bus getBus() {
        return this.bus;
    }

    protected void setBus(Bus bus) {
        this.bus = bus;
    }
}

