/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.metadata.services;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jboss.wsf.common.IOUtils;
import org.jboss.wsf.spi.deployment.WSFDeploymentException;
import org.jboss.wsf.stack.cxf.metadata.services.DDBean;
import org.jboss.wsf.stack.cxf.metadata.services.DDEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DDBeans {
    private List<DDEndpoint> endpoints = new ArrayList<DDEndpoint>();
    private List<DDBean> beans = new ArrayList<DDBean>();
    private File tmpFile;

    public List<DDEndpoint> getEndpoints() {
        return this.endpoints;
    }

    public void addEndpoint(DDEndpoint service) {
        this.endpoints.add(service);
    }

    public List<DDBean> getBeans() {
        return this.beans;
    }

    public void addBean(DDBean bean) {
        this.beans.add(bean);
    }

    public URL createFileURL() {
        this.destroyFileURL();
        try {
            File tmpDir = IOUtils.createTempDirectory();
            this.tmpFile = File.createTempFile("jbossws-cxf", ".xml", tmpDir);
            OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(this.tmpFile));
            this.writeTo(writer);
            ((Writer)writer).close();
            return this.tmpFile.toURL();
        }
        catch (IOException ex) {
            throw new WSFDeploymentException((Throwable)ex);
        }
    }

    public void destroyFileURL() {
        if (this.tmpFile != null) {
            this.tmpFile.delete();
            this.tmpFile = null;
        }
    }

    public void writeTo(Writer writer) throws IOException {
        writer.write("<beans xmlns='http://www.springframework.org/schema/beans' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xmlns:beans='http://www.springframework.org/schema/beans' xmlns:jaxws='http://cxf.apache.org/jaxws' xmlns:soap='http://cxf.apache.org/bindings/soap' xsi:schemaLocation='http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd http://cxf.apache.org/jaxws http://cxf.apache.org/schemas/jaxws.xsd'>");
        for (DDEndpoint endpoint : this.endpoints) {
            endpoint.writeTo(writer);
        }
        for (DDBean bean : this.beans) {
            bean.writeTo(writer);
        }
        writer.write("</beans>");
    }
}

