package org.jboss.wsf.stack.cxf.i18n;

import java.util.Locale;
import org.apache.cxf.Bus;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import java.lang.String;
import org.jboss.logging.Logger;
import java.net.URL;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import java.lang.Class;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2022-06-21T22:53:31+0800")
public class Loggers_$logger extends DelegatingBasicLogger implements Loggers, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Loggers_$logger.class.getName();
    public Loggers_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void cannotUseCurrentDepBusForStartingNewEndpoint() {
        super.log.logf(FQCN, INFO, null, cannotUseCurrentDepBusForStartingNewEndpoint$str());
    }
    protected String cannotUseCurrentDepBusForStartingNewEndpoint$str() {
        return "JBWS024015: Cannot use the bus associated to the current deployment for starting a new endpoint, creating a new bus...";
    }
    @Override
    public final void cannotRetrieveServerConfigIgnoreForClients(final Throwable cause) {
        super.log.logf(FQCN, TRACE, cause, cannotRetrieveServerConfigIgnoreForClients$str());
    }
    protected String cannotRetrieveServerConfigIgnoreForClients$str() {
        return "JBWS024016: Unable to retrieve server config; this is an expected condition for jboss-modules enabled client.";
    }
    @Override
    public final void cannotRetrievePortQNameTryingMatchingUsingEpInterface(final String portName, final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, cannotRetrievePortQNameTryingMatchingUsingEpInterface$str(), portName);
    }
    protected String cannotRetrievePortQNameTryingMatchingUsingEpInterface$str() {
        return "JBWS024018: Unable to retrieve port QName from %s, trying matching port using endpoint interface name only.";
    }
    @Override
    public final void settingNewServiceEndpointAddressInWsdl(final String address) {
        super.log.logf(FQCN, DEBUG, null, settingNewServiceEndpointAddressInWsdl$str(), address);
    }
    protected String settingNewServiceEndpointAddressInWsdl$str() {
        return "JBWS024033: Setting new service endpoint address in wsdl: %s";
    }
    @Override
    public final void addressRewriteRequiredBecauseOfServerConf(final String address) {
        super.log.logf(FQCN, DEBUG, null, addressRewriteRequiredBecauseOfServerConf$str(), address);
    }
    protected String addressRewriteRequiredBecauseOfServerConf$str() {
        return "JBWS024034: WSDL service endpoint address rewrite required because of server configuration: %s";
    }
    @Override
    public final void addressRewriteRequiredBecauseOfInvalidAddress(final String address) {
        super.log.logf(FQCN, DEBUG, null, addressRewriteRequiredBecauseOfInvalidAddress$str(), address);
    }
    protected String addressRewriteRequiredBecauseOfInvalidAddress$str() {
        return "JBWS024035: WSDL service endpoint address rewrite required because of invalid URL: %s";
    }
    @Override
    public final void rewriteNotRequired(final String address) {
        super.log.logf(FQCN, DEBUG, null, rewriteNotRequired$str(), address);
    }
    protected String rewriteNotRequired$str() {
        return "JBWS024036: WSDL service endpoint address rewrite not required: %s";
    }
    @Override
    public final void addressRewritten(final String previousAddress, final String address) {
        super.log.logf(FQCN, DEBUG, null, addressRewritten$str(), previousAddress, address);
    }
    protected String addressRewritten$str() {
        return "JBWS024037: Rewritten new candidate WSDL service endpoint address '%s' to '%s'";
    }
    @Override
    public final void invalidAddressProvidedUseItWithoutRewriting(final String newAddress, final String origAddress) {
        super.log.logf(FQCN, DEBUG, null, invalidAddressProvidedUseItWithoutRewriting$str(), newAddress, origAddress);
    }
    protected String invalidAddressProvidedUseItWithoutRewriting$str() {
        return "JBWS024038: Invalid url '%s' provided, using original one without rewriting: %s";
    }
    @Override
    public final void aboutToAuthenticate(final String securityDomain) {
        super.log.logf(FQCN, TRACE, null, aboutToAuthenticate$str(), securityDomain);
    }
    protected String aboutToAuthenticate$str() {
        return "JBWS024040: About to authenticate, using security domain %s";
    }
    @Override
    public final void authenticated(final String principal) {
        super.log.logf(FQCN, TRACE, null, authenticated$str(), principal);
    }
    protected String authenticated$str() {
        return "JBWS024041: Authenticated, principal=%s";
    }
    @Override
    public final void securityContextPropagated(final String principal) {
        super.log.logf(FQCN, TRACE, null, securityContextPropagated$str(), principal);
    }
    protected String securityContextPropagated$str() {
        return "JBWS024042: Security context propagated for principal %s";
    }
    @Override
    public final void userPrincipalNotAvailableOnCurrentMessage() {
        super.log.logf(FQCN, ERROR, null, userPrincipalNotAvailableOnCurrentMessage$str());
    }
    protected String userPrincipalNotAvailableOnCurrentMessage$str() {
        return "JBWS024054: User principal is not available on the current message";
    }
    @Override
    public final void cannotOpenStream(final String callerClass, final String resourcePath) {
        super.log.logf(FQCN, WARN, null, cannotOpenStream$str(), callerClass, resourcePath);
    }
    protected String cannotOpenStream$str() {
        return "JBWS024059: %s cannot open stream for resource: %s";
    }
    @Override
    public final void cannotResolveResource(final String callerClass, final String resourcePath) {
        super.log.logf(FQCN, DEBUG, null, cannotResolveResource$str(), callerClass, resourcePath);
    }
    protected String cannotResolveResource$str() {
        return "JBWS024060: %s cannot resolve resource: %s";
    }
    @Override
    public final void addingServiceEndpointMetadata(final Object o) {
        super.log.logf(FQCN, INFO, null, addingServiceEndpointMetadata$str(), o);
    }
    protected String addingServiceEndpointMetadata$str() {
        return "JBWS024061: Adding service endpoint metadata: %s";
    }
    @Override
    public final void overridePortName(final String id, final QName portName, final QName newPortName) {
        super.log.logf(FQCN, DEBUG, null, overridePortName$str(), id, portName, newPortName);
    }
    protected String overridePortName$str() {
        return "JBWS024062: id %s, overriding portName %s with %s";
    }
    @Override
    public final void overrideServiceName(final String id, final QName serviceName, final QName newServiceName) {
        super.log.logf(FQCN, DEBUG, null, overrideServiceName$str(), id, serviceName, newServiceName);
    }
    protected String overrideServiceName$str() {
        return "JBWS024063: id %s, overriding portName %s with %s";
    }
    @Override
    public final void enableMTOM(final String id) {
        super.log.logf(FQCN, DEBUG, null, enableMTOM$str(), id);
    }
    protected String enableMTOM$str() {
        return "JBWS024064: id %s, enabling MTOM...";
    }
    @Override
    public final void enableAddressing(final String id) {
        super.log.logf(FQCN, DEBUG, null, enableAddressing$str(), id);
    }
    protected String enableAddressing$str() {
        return "JBWS024065: id %s, enabling Addressing...";
    }
    @Override
    public final void enableRespectBinding(final String id) {
        super.log.logf(FQCN, DEBUG, null, enableRespectBinding$str(), id);
    }
    protected String enableRespectBinding$str() {
        return "JBWS024066: id %s, enabling RespectBinding...";
    }
    @Override
    public final void overridingWsdlFileLocation(final String id, final String wsdlLoc) {
        super.log.logf(FQCN, DEBUG, null, overridingWsdlFileLocation$str(), id, wsdlLoc);
    }
    protected String overridingWsdlFileLocation$str() {
        return "JBWS024067: id %s, overriding wsdlFile location with %s";
    }
    @Override
    public final void filtersNotSupported() {
        super.log.logf(FQCN, WARN, null, filtersNotSupported$str());
    }
    protected String filtersNotSupported$str() {
        return "JBWS024068: Handler chain deployment descriptor contribution: PortNamePattern, ServiceNamePattern and ProtocolBindings filters not supported; adding handlers anyway.";
    }
    @Override
    public final void initParamsSupported(final String handlerName) {
        super.log.logf(FQCN, WARN, null, initParamsSupported$str(), handlerName);
    }
    protected String initParamsSupported$str() {
        return "JBWS024069: Init params not supported, handler: %s";
    }
    @Override
    public final void errorRegisteringBus(final Bus bus, final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, errorRegisteringBus$str(), bus);
    }
    protected String errorRegisteringBus$str() {
        return "JBWS024073: Error registering bus for management: %s";
    }
    @Override
    public final void wsdlFilePublished(final URL url) {
        super.log.logf(FQCN, INFO, null, wsdlFilePublished$str(), url);
    }
    protected String wsdlFilePublished$str() {
        return "JBWS024074: WSDL published to: %s";
    }
    @Override
    public final void cannotGetWsdlPublishLocation() {
        super.log.logf(FQCN, WARN, null, cannotGetWsdlPublishLocation$str());
    }
    protected String cannotGetWsdlPublishLocation$str() {
        return "JBWS024077: Cannot get wsdl publish location for null wsdl location and serviceName";
    }
    @Override
    public final void unableToPublishContractDueToMissingPublisher(final Class<?> clazz) {
        super.log.logf(FQCN, WARN, null, unableToPublishContractDueToMissingPublisher$str(), clazz);
    }
    protected String unableToPublishContractDueToMissingPublisher$str() {
        return "JBWS024078: WSDL publisher not configured, unable to publish contract for endpoint class %s";
    }
    @Override
    public final void actualConfFromFile(final URL url) {
        super.log.logf(FQCN, DEBUG, null, actualConfFromFile$str(), url);
    }
    protected String actualConfFromFile$str() {
        return "JBWS024080: Actual configuration from file: %s";
    }
    @Override
    public final void errorGettingWSSConfig(final Throwable cause) {
        super.log.logf(FQCN, TRACE, cause, errorGettingWSSConfig$str());
    }
    protected String errorGettingWSSConfig$str() {
        return "JBWS024086: Error while getting default WSSConfig";
    }
    @Override
    public final void couldNotInitSecurityEngine() {
        super.log.logf(FQCN, WARN, null, couldNotInitSecurityEngine$str());
    }
    protected String couldNotInitSecurityEngine$str() {
        return "JBWS024087: Could not early initialize security engine";
    }
    @Override
    public final void unableToLoadAdditionalConfigurationFrom(final URL url, final Throwable cause) {
        super.log.logf(FQCN, TRACE, cause, unableToLoadAdditionalConfigurationFrom$str(), url);
    }
    protected String unableToLoadAdditionalConfigurationFrom$str() {
        return "JBWS024089: Unable to load additional configuration from %s";
    }
    @Override
    public final void abortSoapAddressRewrite(final String wsdlLocation, final Throwable cause) {
        super.log.logf(FQCN, DEBUG, cause, abortSoapAddressRewrite$str(), wsdlLocation);
    }
    protected String abortSoapAddressRewrite$str() {
        return "JBWS024091: Could not get WSDL from %s, aborting soap:address rewrite.";
    }
    @Override
    public final void addingPolicyAttachment(final Object placement, final String refId, final Class<?> cls) {
        super.log.logf(FQCN, INFO, null, addingPolicyAttachment$str(), placement, refId, cls);
    }
    protected String addingPolicyAttachment$str() {
        return "JBWS024092: Adding %s policy attachment with id='%s' to honor requirement from %s.";
    }
    @Override
    public final void unknownJAXWSClientBusStrategy(final String strategy) {
        super.log.logf(FQCN, WARN, null, unknownJAXWSClientBusStrategy$str(), strategy);
    }
    protected String unknownJAXWSClientBusStrategy$str() {
        return "JBWS024095: Unknown strategy '%s' requested for selecting the Apache CXF Bus to be used for building JAXWS clients; default strategy will be used.";
    }
    @Override
    public final void couldNotDeleteWsdlFile(final String filename) {
        super.log.logf(FQCN, WARN, null, couldNotDeleteWsdlFile$str(), filename);
    }
    protected String couldNotDeleteWsdlFile$str() {
        return "JBWS024097: Could not delete wsdl file %s";
    }
    @Override
    public final void deletedWsdlFile(final String filename) {
        super.log.logf(FQCN, DEBUG, null, deletedWsdlFile$str(), filename);
    }
    protected String deletedWsdlFile$str() {
        return "JBWS024098: Deleted wsdl file %s";
    }
    @Override
    public final void couldNotCreateWsdlDataPath() {
        super.log.logf(FQCN, WARN, null, couldNotCreateWsdlDataPath$str());
    }
    protected String couldNotCreateWsdlDataPath$str() {
        return "JBWS024099: Could not create wsdl data path.";
    }
    @Override
    public final void couldNotDeleteWsdlDirectory(final String filename) {
        super.log.logf(FQCN, WARN, null, couldNotDeleteWsdlDirectory$str(), filename);
    }
    protected String couldNotDeleteWsdlDirectory$str() {
        return "JBWS024100: Could not delete wsdl directory %s";
    }
    @Override
    public final void cannotFindJaspiClasses() {
        super.log.logf(FQCN, DEBUG, null, cannotFindJaspiClasses$str());
    }
    protected String cannotFindJaspiClasses$str() {
        return "JBWS024102: JASPI authentication isn't enabled, can not find JASPI modules and classes";
    }
    @Override
    public final void cannotLoadBouncyCastleProvider(final String property, final Throwable cause) {
        super.log.logf(FQCN, DEBUG, cause, cannotLoadBouncyCastleProvider$str(), property);
    }
    protected String cannotLoadBouncyCastleProvider$str() {
        return "JBWS024103: Could not load BouncyCastle security provider; either setup your classpath properly or prevent loading by using the '%s' system property.";
    }
    @Override
    public final void couldNotLoadClientBusSelector(final String selector, final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, couldNotLoadClientBusSelector$str(), selector);
    }
    protected String couldNotLoadClientBusSelector$str() {
        return "JBWS024105: Could not create instance of specified ClientBusSelector: %s";
    }
    @Override
    public final void couldNoRemoveFeaturesOnClient(final String feature) {
        super.log.logf(FQCN, WARN, null, couldNoRemoveFeaturesOnClient$str(), feature);
    }
    protected String couldNoRemoveFeaturesOnClient$str() {
        return "JBWS024106: Could not remove previuosly set features on client: %s";
    }
    @Override
    public final void unableToProcessHandlerElement(final Element el, final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, unableToProcessHandlerElement$str(), el);
    }
    protected String unableToProcessHandlerElement$str() {
        return "JBWS024110: Unable to process handler element: %s";
    }
    @Override
    public final void couldNotLoadJBossModuleForClassloader(final String cl) {
        super.log.logf(FQCN, WARN, null, couldNotLoadJBossModuleForClassloader$str(), cl);
    }
    protected String couldNotLoadJBossModuleForClassloader$str() {
        return "JBWS024111: Could not load JBoss module for classloader %s";
    }
    @Override
    public final void unableToCreateConfigRef(final String url, final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, unableToCreateConfigRef$str(), url);
    }
    protected String unableToCreateConfigRef$str() {
        return "JBWS024112: Could not construct reference for config: %s";
    }
    @Override
    public final void noSecurityDomain() {
        super.log.logf(FQCN, ERROR, null, noSecurityDomain$str());
    }
    protected String noSecurityDomain$str() {
        return "JBWS024114: No security domain associated";
    }
    @Override
    public final void failedToComputeUsernameTokenProfileDigest() {
        super.log.logf(FQCN, ERROR, null, failedToComputeUsernameTokenProfileDigest$str());
    }
    protected String failedToComputeUsernameTokenProfileDigest$str() {
        return "JBWS024115: Failed to compute UsernameToken profile digest from expected password";
    }
}
