/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.client;

import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Endpoint;
import javax.xml.ws.EndpointContext;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.spi.Invoker;
import javax.xml.ws.spi.ServiceDelegate;
import javax.xml.ws.spi.http.HttpContext;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.jaxws.DispatchImpl;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.jaxws.ServiceImpl;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.jboss.ws.api.configuration.AbstractClientFeature;
import org.jboss.ws.common.utils.DelegateClassLoader;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.management.ServerConfigFactory;
import org.jboss.wsf.spi.metadata.config.ClientConfig;
import org.jboss.wsf.spi.metadata.config.CommonConfig;
import org.jboss.wsf.stack.cxf.Loggers;
import org.jboss.wsf.stack.cxf.Messages;
import org.jboss.wsf.stack.cxf.client.UseNewBusFeature;
import org.jboss.wsf.stack.cxf.client.configuration.CXFClientConfigurer;
import org.jboss.wsf.stack.cxf.client.configuration.HandlerChainSortInterceptor;
import org.jboss.wsf.stack.cxf.client.configuration.JBossWSBusFactory;
import org.w3c.dom.Element;

public class ProviderImpl
extends org.apache.cxf.jaxws22.spi.ProviderImpl {
    private static final boolean jbossModulesEnv;
    private static ServerConfig serverConfig;
    private static boolean serverConfigInit;

    protected EndpointImpl createEndpointImpl(Bus bus, String bindingId, Object implementor, WebServiceFeature ... features) {
        Boolean db = (Boolean)bus.getProperty("deployment-bus");
        if (db != null && db.booleanValue()) {
            Loggers.ROOT_LOGGER.cannotUseCurrentDepBusForStartingNewEndpoint();
            bus = BusFactory.newInstance().createBus();
        }
        return super.createEndpointImpl(bus, bindingId, implementor, features);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint createEndpoint(String bindingId, Object implementor) {
        ClassLoader origClassLoader = ProviderImpl.getContextClassLoader();
        boolean restoreTCCL = false;
        try {
            restoreTCCL = ProviderImpl.checkAndFixContextClassLoader(origClassLoader);
            ProviderImpl.setValidThreadDefaultBus();
            DelegateEndpointImpl delegateEndpointImpl = new DelegateEndpointImpl(super.createEndpoint(bindingId, implementor));
            return delegateEndpointImpl;
        }
        finally {
            if (restoreTCCL) {
                ProviderImpl.setContextClassLoader(origClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint createEndpoint(String bindingId, Object implementor, WebServiceFeature ... features) {
        ClassLoader origClassLoader = ProviderImpl.getContextClassLoader();
        boolean restoreTCCL = false;
        try {
            restoreTCCL = ProviderImpl.checkAndFixContextClassLoader(origClassLoader);
            ProviderImpl.setValidThreadDefaultBus();
            DelegateEndpointImpl delegateEndpointImpl = new DelegateEndpointImpl(super.createEndpoint(bindingId, implementor, features));
            return delegateEndpointImpl;
        }
        finally {
            if (restoreTCCL) {
                ProviderImpl.setContextClassLoader(origClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint createEndpoint(String bindingId, Class<?> implementorClass, Invoker invoker, WebServiceFeature ... features) {
        ClassLoader origClassLoader = ProviderImpl.getContextClassLoader();
        boolean restoreTCCL = false;
        try {
            restoreTCCL = ProviderImpl.checkAndFixContextClassLoader(origClassLoader);
            ProviderImpl.setValidThreadDefaultBus();
            DelegateEndpointImpl delegateEndpointImpl = new DelegateEndpointImpl(super.createEndpoint(bindingId, implementorClass, invoker, features));
            return delegateEndpointImpl;
        }
        finally {
            if (restoreTCCL) {
                ProviderImpl.setContextClassLoader(origClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceDelegate createServiceDelegate(URL url, QName qname, Class cls) {
        ClassLoader origClassLoader = ProviderImpl.getContextClassLoader();
        boolean restoreTCCL = false;
        try {
            restoreTCCL = ProviderImpl.checkAndFixContextClassLoader(origClassLoader);
            Bus bus = ProviderImpl.setValidThreadDefaultBus();
            JBossWSServiceImpl jBossWSServiceImpl = new JBossWSServiceImpl(bus, url, qname, cls, new WebServiceFeature[0]);
            return jBossWSServiceImpl;
        }
        finally {
            if (restoreTCCL) {
                ProviderImpl.setContextClassLoader(origClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceDelegate createServiceDelegate(URL wsdlDocumentLocation, QName serviceName, Class serviceClass, WebServiceFeature ... features) {
        ClassLoader origClassLoader = ProviderImpl.getContextClassLoader();
        boolean restoreTCCL = false;
        try {
            JBossWSServiceImpl jBossWSServiceImpl;
            block12: {
                restoreTCCL = ProviderImpl.checkAndFixContextClassLoader(origClassLoader);
                boolean createNewBus = false;
                for (WebServiceFeature f : features) {
                    String fName = f.getClass().getName();
                    if (!fName.startsWith("javax.xml.ws") && !fName.startsWith("org.jboss.ws")) {
                        throw Messages.MESSAGES.unknownFeature(f.getClass().getName());
                    }
                    if (!fName.equals(UseNewBusFeature.class.getName())) continue;
                    createNewBus = f.isEnabled();
                }
                if (!createNewBus) {
                    Bus bus = ProviderImpl.setValidThreadDefaultBus();
                    JBossWSServiceImpl len$ = new JBossWSServiceImpl(bus, wsdlDocumentLocation, serviceName, serviceClass, features);
                    return len$;
                }
                Bus orig = null;
                try {
                    orig = BusFactory.getThreadDefaultBus((boolean)false);
                    Bus bus = BusFactory.newInstance().createBus();
                    jBossWSServiceImpl = new JBossWSServiceImpl(bus, wsdlDocumentLocation, serviceName, serviceClass, features);
                    if (orig == null) break block12;
                }
                catch (Throwable throwable) {
                    if (orig != null) {
                        BusFactory.setThreadDefaultBus((Bus)orig);
                    }
                    throw throwable;
                }
                BusFactory.setThreadDefaultBus((Bus)orig);
            }
            return jBossWSServiceImpl;
        }
        finally {
            if (restoreTCCL) {
                ProviderImpl.setContextClassLoader(origClassLoader);
            }
        }
    }

    static boolean checkAndFixContextClassLoader(ClassLoader origClassLoader) {
        try {
            origClassLoader.loadClass(ProviderImpl.class.getName());
        }
        catch (Exception e) {
            ClassLoader clientClassLoader = ProviderImpl.class.getClassLoader();
            if (BusFactory.getDefaultBus((boolean)false) == null) {
                JBossWSBusFactory.getDefaultBus(clientClassLoader);
            }
            ProviderImpl.setContextClassLoader((ClassLoader)ProviderImpl.createDelegateClassLoader(clientClassLoader, origClassLoader));
            return true;
        }
        return false;
    }

    static Bus setValidThreadDefaultBus() {
        Bus bus = BusFactory.getThreadDefaultBus((boolean)false);
        if (bus == null) {
            bus = BusFactory.newInstance().createBus();
        }
        return bus;
    }

    private static DelegateClassLoader createDelegateClassLoader(final ClassLoader clientClassLoader, final ClassLoader origClassLoader) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return new DelegateClassLoader(clientClassLoader, origClassLoader);
        }
        return AccessController.doPrivileged(new PrivilegedAction<DelegateClassLoader>(){

            @Override
            public DelegateClassLoader run() {
                return new DelegateClassLoader(clientClassLoader, origClassLoader);
            }
        });
    }

    static ClassLoader getContextClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static void setContextClassLoader(final ClassLoader classLoader) {
        if (System.getSecurityManager() == null) {
            Thread.currentThread().setContextClassLoader(classLoader);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized ServerConfig getServerConfig() {
        if (!serverConfigInit) {
            try {
                ClassLoader cl = ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader();
                serverConfig = ((ServerConfigFactory)SPIProvider.getInstance().getSPI(ServerConfigFactory.class, cl)).getServerConfig();
            }
            catch (Exception e) {
                Loggers.ROOT_LOGGER.cannotRetrieveServerConfigIgnoreForClients(e);
            }
            finally {
                serverConfigInit = true;
            }
        }
        return serverConfig;
    }

    static {
        serverConfig = null;
        serverConfigInit = false;
        jbossModulesEnv = ProviderImpl.class.getClassLoader() != org.apache.cxf.jaxws22.spi.ProviderImpl.class.getClassLoader();
    }

    static final class JBossWSServiceImpl
    extends ServiceImpl {
        public JBossWSServiceImpl(Bus b, URL url, QName name, Class<?> cls, WebServiceFeature ... f) {
            super(b, url, name, cls, f);
        }

        protected <T> T createPort(QName portName, EndpointReferenceType epr, Class<T> serviceEndpointInterface, WebServiceFeature ... features) {
            Object port = super.createPort(portName, epr, serviceEndpointInterface, features);
            this.setupClient(port, features);
            return (T)port;
        }

        public <T> Dispatch<T> createDispatch(QName portName, Class<T> type, JAXBContext context, Service.Mode mode, WebServiceFeature ... features) {
            Dispatch dispatch = super.createDispatch(portName, type, context, mode, features);
            this.setupClient(dispatch, features);
            return dispatch;
        }

        protected void setupClient(Object obj, WebServiceFeature ... features) {
            ServerConfig sc;
            Binding binding = ((BindingProvider)obj).getBinding();
            Client client = obj instanceof DispatchImpl ? ((DispatchImpl)obj).getClient() : ClientProxy.getClient((Object)obj);
            client.getOutInterceptors().add(new HandlerChainSortInterceptor(binding));
            if (jbossModulesEnv && (sc = ProviderImpl.getServerConfig()) != null) {
                for (ClientConfig config : sc.getClientConfigs()) {
                    if (!config.getConfigName().equals("Standard-Client-Config")) continue;
                    CXFClientConfigurer helper = new CXFClientConfigurer();
                    helper.setupConfigHandlers(binding, (CommonConfig)config);
                    helper.setConfigProperties(client, config.getProperties());
                }
            }
            if (features != null) {
                for (WebServiceFeature f : features) {
                    if (!(f instanceof AbstractClientFeature)) continue;
                    ((AbstractClientFeature)f).initialize(obj);
                }
            }
        }
    }

    static final class DelegateEndpointImpl
    extends Endpoint {
        private Endpoint delegate;

        public DelegateEndpointImpl(Endpoint delegate) {
            this.delegate = delegate;
        }

        public Binding getBinding() {
            return this.delegate.getBinding();
        }

        public Object getImplementor() {
            return this.delegate.getImplementor();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void publish(String address) {
            ClassLoader origClassLoader = ProviderImpl.getContextClassLoader();
            boolean restoreTCCL = false;
            try {
                restoreTCCL = ProviderImpl.checkAndFixContextClassLoader(origClassLoader);
                this.delegate.publish(address);
            }
            finally {
                if (restoreTCCL) {
                    ProviderImpl.setContextClassLoader(origClassLoader);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void publish(Object serverContext) {
            ClassLoader origClassLoader = ProviderImpl.getContextClassLoader();
            boolean restoreTCCL = false;
            try {
                restoreTCCL = ProviderImpl.checkAndFixContextClassLoader(origClassLoader);
                this.delegate.publish(serverContext);
            }
            finally {
                if (restoreTCCL) {
                    ProviderImpl.setContextClassLoader(origClassLoader);
                }
            }
        }

        public void stop() {
            this.delegate.stop();
        }

        public boolean isPublished() {
            return this.delegate.isPublished();
        }

        public List<Source> getMetadata() {
            return this.delegate.getMetadata();
        }

        public void setMetadata(List<Source> metadata) {
            this.delegate.setMetadata(metadata);
        }

        public Executor getExecutor() {
            return this.delegate.getExecutor();
        }

        public void setExecutor(Executor executor) {
            this.delegate.setExecutor(executor);
        }

        public Map<String, Object> getProperties() {
            return this.delegate.getProperties();
        }

        public void setProperties(Map<String, Object> properties) {
            this.delegate.setProperties(properties);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EndpointReference getEndpointReference(Element ... referenceParameters) {
            ClassLoader origClassLoader = ProviderImpl.getContextClassLoader();
            boolean restoreTCCL = false;
            try {
                restoreTCCL = ProviderImpl.checkAndFixContextClassLoader(origClassLoader);
                EndpointReference endpointReference = this.delegate.getEndpointReference(referenceParameters);
                return endpointReference;
            }
            finally {
                if (restoreTCCL) {
                    ProviderImpl.setContextClassLoader(origClassLoader);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T extends EndpointReference> T getEndpointReference(Class<T> clazz, Element ... referenceParameters) {
            ClassLoader origClassLoader = ProviderImpl.getContextClassLoader();
            boolean restoreTCCL = false;
            try {
                restoreTCCL = ProviderImpl.checkAndFixContextClassLoader(origClassLoader);
                EndpointReference endpointReference = this.delegate.getEndpointReference(clazz, referenceParameters);
                return (T)endpointReference;
            }
            finally {
                if (restoreTCCL) {
                    ProviderImpl.setContextClassLoader(origClassLoader);
                }
            }
        }

        public void setEndpointContext(EndpointContext ctxt) {
            this.delegate.setEndpointContext(ctxt);
        }

        public void publish(HttpContext context) {
            this.delegate.publish(context);
        }
    }
}

