/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.tools;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.cxf.helpers.FileUtils;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.wsdlto.WSDLToJava;
import org.jboss.ws.api.tools.WSContractConsumer;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.utils.NullPrintStream;

public class CXFConsumerImpl
extends WSContractConsumer {
    private static final ResourceBundle bundle = BundleUtils.getBundle(CXFConsumerImpl.class);
    private List<File> bindingFiles = null;
    private File catalog = null;
    private boolean extension;
    private boolean generateSource = false;
    private File outputDir = new File("output");
    private File sourceDir = null;
    private String targetPackage = null;
    private PrintStream messageStream = null;
    private String wsdlLocation = null;
    private List<String> additionalCompilerClassPath = new ArrayList<String>();
    private boolean additionalHeaders = false;
    private String target;
    private boolean nocompile = false;

    public void setBindingFiles(List<File> bindingFiles) {
        this.bindingFiles = bindingFiles;
    }

    public void setCatalog(File catalog) {
        this.catalog = catalog;
    }

    public void setExtension(boolean extension) {
        this.extension = extension;
    }

    public void setGenerateSource(boolean generateSource) {
        this.generateSource = generateSource;
    }

    public void setMessageStream(PrintStream messageStream) {
        this.messageStream = messageStream;
    }

    public void setOutputDirectory(File directory) {
        this.outputDir = directory;
    }

    public void setSourceDirectory(File directory) {
        this.sourceDir = directory;
    }

    public void setTargetPackage(String targetPackage) {
        this.targetPackage = targetPackage;
    }

    public void setWsdlLocation(String wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }

    public void setAdditionalCompilerClassPath(List<String> additionalCompilerClassPath) {
        this.additionalCompilerClassPath = additionalCompilerClassPath;
    }

    public void setAdditionalHeaders(boolean additionalHeaders) {
        this.additionalHeaders = additionalHeaders;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setNoCompile(boolean nocompile) {
        this.nocompile = nocompile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consume(URL wsdl) {
        ArrayList<String> args = new ArrayList<String>();
        PrintStream stream = this.messageStream;
        boolean verbose = false;
        if (stream != null) {
            verbose = true;
        } else {
            stream = NullPrintStream.getInstance();
        }
        if ("2.1".equals(this.target)) {
            args.add("-frontend");
            args.add("jaxws21");
        } else if (this.target != null && !this.target.equals("2.2")) {
            stream.println("Unsupported target, using default value '2.2'");
        }
        if (this.bindingFiles != null) {
            for (File file : this.bindingFiles) {
                args.add("-b");
                args.add(file.getAbsolutePath());
            }
        }
        if (this.catalog != null) {
            args.add("-catalog");
            args.add(this.catalog.getAbsolutePath());
        }
        if (!this.nocompile) {
            args.add("-compile");
        }
        args.add("-exsh");
        args.add(this.additionalHeaders ? "true" : "false");
        if (this.targetPackage != null) {
            args.add("-p");
            args.add(this.targetPackage);
        }
        File sourceTempDir = null;
        if (this.generateSource) {
            if (this.sourceDir == null) {
                this.sourceDir = this.outputDir;
            }
            if (!this.sourceDir.exists() && !this.sourceDir.mkdirs()) {
                throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"COULD_NOT_MAKE_DIRECTORY", (Object[])new Object[]{this.sourceDir.getName()}));
            }
            args.add("-d");
            args.add(this.sourceDir.getAbsolutePath());
        } else {
            sourceTempDir = new File(this.outputDir, "tmp" + Math.round(Math.random() * 1.0E7));
            FileUtils.mkDir((File)sourceTempDir);
            args.add("-d");
            args.add(sourceTempDir.getAbsolutePath());
        }
        if (this.wsdlLocation != null) {
            args.add("-wsdlLocation");
            args.add(this.wsdlLocation);
        }
        if (verbose) {
            args.add("-verbose");
        }
        if (this.extension) {
            stream.println("TODO! Cheek SOAP 1.2 extension");
        }
        if (!this.outputDir.exists() && !this.outputDir.mkdirs()) {
            throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"COULD_NOT_MAKE_DIRECTORY", (Object[])new Object[]{this.outputDir.getName()}));
        }
        if (!this.nocompile) {
            args.add("-classdir");
            args.add(this.outputDir.getAbsolutePath());
        }
        args.add("-allowElementReferences");
        args.add(wsdl.toString());
        if (!this.additionalCompilerClassPath.isEmpty()) {
            StringBuffer javaCP = new StringBuffer();
            for (String s : this.additionalCompilerClassPath) {
                javaCP.append(s).append(File.pathSeparator);
            }
            System.setProperty("java.class.path", javaCP.toString());
        }
        WSDLToJava w2j = new WSDLToJava(args.toArray(new String[0]));
        try {
            w2j.run(new ToolContext(), (OutputStream)stream);
        }
        catch (Throwable t) {
            if (this.messageStream != null) {
                this.messageStream.println("Failed to invoke WSDLToJava");
                t.printStackTrace(this.messageStream);
            } else {
                t.printStackTrace();
            }
        }
        finally {
            if (sourceTempDir != null) {
                FileUtils.removeDir((File)sourceTempDir);
            }
        }
    }
}

